/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ejb3.test.regression.salesforce7123;

import java.util.List;
import java.util.ArrayList;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.annotation.EJB;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
@Stateless
public class MyBusinessSessionBean implements MyBusinessSessionRemote
{
   @EJB DataAccess dao;

   @TransactionAttribute(TransactionAttributeType.NOT_SUPPORTED)
   public List getMyBeans()
   {
      List nodeList = new ArrayList();
      List data = dao.findMyBeans();

      int counter = 0;
      for (Object obj : data)
      {
         BaseData d = (BaseData)obj;
         d.prepareTransport();
         nodeList.add(d);
         // change the name too
         d.setName(((Integer)(counter++)).toString());
      }
      return nodeList;
   }
}
