/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.security;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Set;
import java.util.HashSet;

import javax.security.auth.Subject;

import javax.ejb.EJBAccessException;

import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.logging.Logger;

import org.jboss.annotation.security.SecurityDomain;

import org.jboss.aspects.security.AuthenticationInterceptor;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
public class Ejb3AuthenticationInterceptor extends AuthenticationInterceptor
{
   private static final Logger log = Logger.getLogger(Ejb3AuthenticationInterceptor.class);

   private EJBContainer container;
   protected RealmMapping realmMapping;

   public Ejb3AuthenticationInterceptor(AuthenticationManager manager, Container container)
   {
      super(manager);
      this.container = (EJBContainer)container;
      this.realmMapping = (RealmMapping)manager;
   }

   protected void handleGeneralSecurityException(GeneralSecurityException gse)
   {
      throw new EJBAccessException("Authentication failure", gse);
   }


}
