/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.InjectionTarget;
import org.jboss.logging.Logger;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
public class InjectionUtil
{
   private static final Logger log = Logger
   .getLogger(InjectionUtil.class);
   
   public static AccessibleObject findInjectionTarget(Class injectionClass, InjectionTarget target)
   {
      Class clazz = injectionClass;
      if (clazz == null) throw new NullPointerException("clazz was null???");
      System.out.println(clazz.getName());
      String targetClass = target.getTargetClass();
      String targetName = target.getTargetName();
      String className = clazz.getName();
      if (targetClass == null) throw new NullPointerException("injection-target-class was null");
      if (className == null) throw new NullPointerException("className was null");
    
      while (!className.equals(targetClass))
      {
         if (clazz.equals(Object.class))
            throw new RuntimeException("invocation target class not found: " + targetClass + " of class: " + injectionClass);
         clazz = clazz.getSuperclass();
      }

      for (Field field : clazz.getDeclaredFields())
      {
         if (target.getTargetName().equals(field.getName())) return field;
      }

      for (java.lang.reflect.Method method : clazz.getDeclaredMethods())
      {
         if (method.getName().equals(target.getTargetName())) return method;
      }

      throw new RuntimeException("invocation target could not be found: " + target.getTargetClass() + "." + target.getTargetName() + " of class: " + injectionClass);

   }

   public static String getEncName(Method method)
   {
      String encName = method.getName().substring(3);
      if (encName.length() > 1)
      {
         encName = encName.substring(0, 1).toLowerCase() + encName.substring(1);
      }
      else
      {
         encName = encName.toLowerCase();
      }

      encName = "env/" + method.getDeclaringClass().getName() + "/" + encName;
      return encName;
   }

   public static String getEncName(Field field)
   {
      return "env/" + field.getDeclaringClass().getName() + "/" + field.getName();
   }
   
   public static Object getAnnotation(Class annotation, EJBContainer container, Class annotatedClass, boolean isContainer)
   {
      if (isContainer)
      {
         return container.resolveAnnotation(annotation);
      }
      else
      {
         return annotatedClass.getAnnotation(annotation);
      }
   }

   public static Object getAnnotation(Class annotation, EJBContainer container, Method method, boolean isContainer)
   {
      if (isContainer)
      {
         return container.resolveAnnotation(method, annotation);
      }
      else
      {
         return method.getAnnotation(annotation);
      }
   }

   public static Object getAnnotation(Class annotation, EJBContainer container, Field field, boolean isContainer)
   {
      if (isContainer)
      {
         return container.resolveAnnotation(field, annotation);
      }
      else
      {
         return field.getAnnotation(annotation);
      }
   }

}
