/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.ejb3.cache.tree;

import java.util.HashMap;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.ejb3.stateful.StatefulBeanContext;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
public class StatefulEvictionPolicy extends PassivationEvictionPolicy
{

   public StatefulEvictionPolicy()
   {
   }

   public void evict(Fqn fqn) throws Exception
   {
      // never allow root node to be evicted
      if (fqn.size() == 2)
      {
         Node node = cache_.get(fqn);
         StatefulBeanContext bean = (StatefulBeanContext) node.getData().get("bean");
         if (bean == null)
         {
            superEvict(fqn);
            return;
         }
         synchronized (bean)
         {
            if (bean.inUse)
            {
               bean.markedForPassivation = true;
               superEvict(fqn);
               return;
            }
            superEvict(fqn);
            passivate(node, bean);
         }
      }
   }

   public void passivate(Node node, StatefulBeanContext bean) throws Exception
   {
      ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
      try
      {
         bean.prePassivate();
         fileCacheLoader.put(node.getFqn(), node.getData(), true);
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(oldCl);
      }
   }

   public void passivate(Fqn fqn, StatefulBeanContext bean) throws Exception
   {
      ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
      try
      {
         bean.prePassivate();
         HashMap map = new HashMap();
         map.put("bean", bean);
         fileCacheLoader.put(fqn, map, true);
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(oldCl);
      }
   }


}
