/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.cache.tree;

import java.util.Properties;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionNameConflictException;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.system.server.ServerConfig;
import org.jboss.util.xml.XmlHelper;
import org.w3c.dom.Element;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
public class PassivationEvictionPolicy extends LRUPolicy
{
   protected FileCacheLoader fileCacheLoader = new FileCacheLoader();

   public void createRegion(String name, int maxSize, long timeToLive)
   {
      if (regionManager_.hasRegion(name)) return;
      try
      {
         Region region = regionManager_.createRegion(name, getEvictionAlgorithm());
         region.setTimeToLiveSeconds(timeToLive);
         region.setMaxNodes(maxSize);
      }
      catch (RegionNameConflictException e)
      {
         throw new RuntimeException(e);
      }
   }

   public void removeRegion(String name)
   {
      regionManager_.removeRegion(name);
   }

   public void superEvict(Fqn fqn) throws Exception
   {
      super.evict(fqn);
   }

   public void evict(Fqn fqn) throws Exception
   {
      Node node = cache_.get(fqn);
      //System.out.println("EVICTING: " + fqn.toString() + " size: " + fqn.size() + " 0: " + fqn.get(0));
      fileCacheLoader.put(fqn, node.getData(), true);
      super.evict(fqn);
   }

   public void configure(TreeCache cache)
   {
      super.configure(cache);
      Element elem = cache.getEvictionPolicyConfig();
      try
      {
         String name = XmlHelper.getUniqueChildContent(elem, "name");
         String filename = System.getProperty(ServerConfig.SERVER_TEMP_DIR) + "/" + name;
         Properties p = new Properties();
         p.put("location", filename);
         fileCacheLoader.setConfig(p);
         fileCacheLoader.create();
         fileCacheLoader.start();
      }
      catch (Exception e)
      {
         throw new RuntimeException(e);
      }
   }
}
