/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.cache.tree;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.system.server.ServerConfig;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
public class PassivationCacheLoader extends FileCacheLoader
{
   protected String filename;

   public void setConfig(Properties p)
   {
      String url = p.getProperty("location");
      String filename = System.getProperty(ServerConfig.SERVER_TEMP_DIR) + "/" + url;
      File fp = new File(filename);
      fp.mkdirs();
      p.setProperty("location", filename);
      super.setConfig(p);
   }

   public Set getChildrenNames(Fqn fqn) throws Exception
   {

      return null;
   }

   public Object get(Fqn fqn, Object key) throws Exception
   {
      throw new Exception("NOT IMPLEMENTED");
   }


   public Map get(Fqn fqn) throws Exception
   {
      Map map = super.get(fqn);
      if (map != null)
      {
         // remove the SFSB from disk when loaded
         remove(fqn);
      }
      return map;
   }

   public Object put(Fqn fqn, Object key, Object value) throws Exception
   {
      return null;
   }

   public void put(Fqn fqn, Map attributes) throws Exception
   {
   }

   public void put(Fqn fqn, Map attributes, boolean erase) throws Exception
   {
   }

   public void put(List modifications) throws Exception
   {
   }
}
