package org.jboss.resource.adapter.jdbc.vendor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

/**
 * Checks a PostgreSQL to see if it is alive. Uses an empty query.
 * 
 * @author <a href="mike@middlesoft.co.uk">Michael Barker</a>
 * @author <a href="weston.price@jboss.com">Weston Price</a>
 */
public class PostgreSQLValidConnectionChecker implements ValidConnectionChecker, Serializable

{
   private static final long serialVersionUID = 4867167301823753925L;

   /**
    * @see org.jboss.resource.adapter.jdbc.ValidConnectionChecker#isValidConnection(java.sql.Connection)
    */
   public SQLException isValidConnection(Connection cn)
   {
      SQLException ex = null;
      Statement stmt = null;
      try
      {
         stmt = cn.createStatement();
         stmt.execute("");
      }
      catch (SQLException e)
      {
         ex = e;
      }
      finally
      {
         if (stmt != null)
         {
            try
            {
               stmt.close();
            }
            catch (Exception e)
            {
            }
         }
      }
      return ex;
   }
}
