/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.xml.binding;

import org.xml.sax.Attributes;

/**
 * Direct implementations of ObjectModelFactory interface can be thought of as "typed" factories
 * in a sense that arguments of newChild, addChild and setValue methods are supposed to be specific Java classes
 * (other than java.lang.Object) from the target class hierarchy.
 * In GenericObjectModelFactory arguments of newChild, addChild and setValue are all of type java.lang.Object.
 * The framework won't introspect an implementation of the GenericObjectModelFactory for "typed" newChild, addChild and setValue.
 * Instead it will call the generic methods and it's the responsibility of the implementation to recognize the types
 * and build the object model.
 *
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision$</tt>
 */
public interface GenericObjectModelFactory
   extends ObjectModelFactory
{
   Object newChild(Object parent,
                   ContentNavigator navigator,
                   String namespaceURI,
                   String localName,
                   Attributes attrs);

   void addChild(Object parent,
                 Object child,
                 ContentNavigator navigator,
                 String namespaceURI,
                 String localName);

   void setValue(Object o,
                 ContentNavigator navigator,
                 String namespaceURI,
                 String localName,
                 String value);

   Object completedRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName);
}
