/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.xml.binding;

import org.apache.xerces.xs.XSTypeDefinition;

import javax.xml.namespace.QName;
import java.util.Map;

/**
 * An interface for content navigation. At the moment it has only one method to get child's content.
 * But it could also implement XPath navigation.
 *
 * @version <tt>$Revision$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public interface ContentNavigator
{
   Map getPrefixToNamespaceMap();
   
   /**
    * @param prefix  the prefix to resolve
    * @return the namespace URI the prefix was mapped to
    */
   String resolveNamespacePrefix(String prefix);

   /** Construct a QName from a value
    * @param value A value that is of the form [prefix:]localpart
    */
   QName resolveQName(String value);

   String getChildContent(String namespaceURI, String qName);

   XSTypeDefinition getType();
}