/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.junitejb;

import java.lang.reflect.Constructor;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.transaction.SystemException;
import net.sourceforge.junitejb.EJBTestCase;
import net.sourceforge.junitejb.RemoteTestException;

public class EJBTestRunnerBean
implements SessionBean {
    private transient SessionContext ctx;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * Loose catch block
     */
    public void run(String className, String methodName) throws RemoteTestException {
        block14: {
            RemoteTestException exception;
            EJBTestCase testCase;
            block11: {
                testCase = this.getTestInstance(className, methodName);
                this.setUpEJB(testCase);
                exception = null;
                this.runTestCase(testCase);
                Object var7_5 = null;
                try {
                    this.tearDownEJB(testCase);
                }
                catch (RemoteTestException e2) {
                    if (exception == null) break block11;
                    exception = e2;
                }
            }
            if (exception != null) {
                throw exception;
            }
            break block14;
            {
                catch (RemoteTestException e) {
                    block12: {
                        exception = e;
                        Object var7_6 = null;
                        try {
                            this.tearDownEJB(testCase);
                        }
                        catch (RemoteTestException e2) {
                            if (exception == null) break block12;
                            exception = e2;
                        }
                    }
                    if (exception != null) {
                        throw exception;
                    }
                }
            }
            catch (Throwable throwable) {
                block13: {
                    Object var7_7 = null;
                    try {
                        this.tearDownEJB(testCase);
                    }
                    catch (RemoteTestException e2) {
                        if (exception == null) break block13;
                        exception = e2;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
        }
    }

    private void setUpEJB(EJBTestCase testCase) throws RemoteTestException {
        try {
            this.ctx.getUserTransaction().begin();
            try {
                testCase.setUpEJB();
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
            if (this.ctx.getUserTransaction().getStatus() == 0) {
                this.ctx.getUserTransaction().commit();
            }
        }
        catch (Throwable e) {
            try {
                this.ctx.getUserTransaction().rollback();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)e;
            }
            throw new RemoteTestException(e);
        }
    }

    private void runTestCase(EJBTestCase testCase) throws RemoteTestException {
        try {
            this.ctx.getUserTransaction().begin();
            try {
                testCase.runBare();
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
            if (this.ctx.getUserTransaction().getStatus() == 0) {
                this.ctx.getUserTransaction().commit();
            }
        }
        catch (Throwable e) {
            try {
                this.ctx.getUserTransaction().rollback();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)e;
            }
            throw new RemoteTestException(e);
        }
    }

    private void tearDownEJB(EJBTestCase testCase) throws RemoteTestException {
        try {
            this.ctx.getUserTransaction().begin();
            try {
                testCase.tearDownEJB();
            }
            catch (Throwable e) {
                throw new RemoteTestException(e);
            }
            if (this.ctx.getUserTransaction().getStatus() == 0) {
                this.ctx.getUserTransaction().commit();
            }
        }
        catch (Throwable e) {
            try {
                this.ctx.getUserTransaction().rollback();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            if (e instanceof RemoteTestException) {
                throw (RemoteTestException)e;
            }
            throw new RemoteTestException(e);
        }
    }

    private EJBTestCase getTestInstance(String className, String methodName) {
        Class<?> testClass = null;
        try {
            testClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException("Test class not found : " + className);
        }
        Constructor<?> constructor = null;
        try {
            constructor = testClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = EJBTestRunnerBean.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException("Test class does not have a constructor which has a single String argument.");
        }
        try {
            EJBTestCase testCase = (EJBTestCase)((Object)constructor.newInstance(methodName));
            testCase.setServerSide(true);
            return testCase;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException("Cannot instantiate test class: " + testClass.getName());
        }
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext ctx) {
        this.ctx = ctx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

