/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

/*
 * Signature claims super is java.util.AbstractQueue<E>, not edu.emory.mathcs.backport.java.util.AbstractQueue - discarding signature.
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayQueue
extends AbstractQueue
implements BlockingQueue {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    private final PriorityQueue<E> q = new edu.emory.mathcs.backport.java.util.PriorityQueue();
    static final /* synthetic */ boolean $assertionsDisabled;

    public DelayQueue() {
    }

    public DelayQueue(Collection<? extends E> c) {
        this.addAll(c);
    }

    public boolean add(E e) {
        return this.offer((E)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed first = (Delayed)this.q.peek();
            this.q.offer(e);
            if (first == null || e.compareTo((Object)first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void put(E e) {
        this.offer((E)e);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean offer(Delayed e, long timeout, TimeUnit unit) {
        return this.offer((E)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed first = (Delayed)this.q.peek();
            if (first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                Object e = null;
                return e;
            }
            Delayed x = (Delayed)this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Delayed delayed = x;
            return delayed;
        }
        finally {
            lock.unlock();
        }
    }

    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Delayed first;
                if ((first = (Delayed)this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    long l = delay;
                    Condition condition = this.available;
                    long l2 = 0L;
                    l2 = (long)condition.await(l, TimeUnit.NANOSECONDS);
                    continue;
                }
                Delayed x = (Delayed)this.q.poll();
                if (!$assertionsDisabled && x == null) {
                    throw new AssertionError();
                }
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Delayed delayed = x;
                return delayed;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public Delayed poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                long l;
                Condition condition;
                long l2;
                Delayed first;
                if ((first = (Delayed)this.q.peek()) == null) {
                    if (nanos <= 0L) {
                        Delayed delayed = null;
                        return delayed;
                    }
                    l2 = nanos;
                    condition = this.available;
                    l = 0L;
                    nanos = l = (long)condition.await(l2, TimeUnit.NANOSECONDS);
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    if (nanos <= 0L) {
                        Delayed delayed = null;
                        return delayed;
                    }
                    if (delay > nanos) {
                        delay = nanos;
                    }
                    l2 = delay;
                    condition = this.available;
                    l = 0L;
                    long timeLeft = l = (long)condition.await(l2, TimeUnit.NANOSECONDS);
                    nanos -= delay - timeLeft;
                    continue;
                }
                Delayed x = (Delayed)this.q.poll();
                if (!$assertionsDisabled && x == null) {
                    throw new AssertionError();
                }
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Delayed delayed = x;
                return delayed;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed delayed = (Delayed)this.q.peek();
            return delayed;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed first;
            int n = 0;
            while ((first = (Delayed)this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed first;
            int n;
            for (n = 0; n < maxElements && (first = (Delayed)this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                c.add(this.q.poll());
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray(a);
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    static {
        $assertionsDisabled = !Class.forName("org.jboss.util.concurrent.DelayQueue").desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return (Delayed)this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            DelayQueue.this.lock.lock();
            try {
                Iterator it = DelayQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    return;
                }
            }
            finally {
                DelayQueue.this.lock.unlock();
            }
        }
    }
}

