/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools;

import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.TreeSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import org.jboss.lang.JBossStringBuilder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindExceptionCtorChanges {
    static Logger log = Logger.getLogger("FindExceptionCtorChanges");

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: FindExceptionCtorChanges path-to-jdk14/rt.jar path-to-jdk15/rt.jar");
        }
        String jdk14Jar = args[0];
        JarFile jdk14JarFile = new JarFile(jdk14Jar);
        ClassPool jdk14Pool = new ClassPool();
        jdk14Pool.appendClassPath(jdk14Jar);
        CtClass jdk14Throwable = jdk14Pool.get("java.lang.Throwable");
        HashMap<String, CtClass> throwables14 = new HashMap<String, CtClass>();
        FindExceptionCtorChanges.scanJar(jdk14JarFile, jdk14Pool, jdk14Throwable, throwables14);
        log.info(new JBossStringBuilder().append("jdk14 throwable count: ").append(throwables14.size()).toString());
        String jdk5Jar = args[1];
        JarFile jdk5JarFile = new JarFile(jdk5Jar);
        ClassPool jdk5Pool = new ClassPool();
        jdk5Pool.appendClassPath(jdk5Jar);
        CtClass jdk5Throwable = jdk5Pool.get("java.lang.Throwable");
        HashMap<String, CtClass> throwables5 = new HashMap<String, CtClass>();
        FindExceptionCtorChanges.scanJar(jdk5JarFile, jdk5Pool, jdk5Throwable, throwables5);
        log.info(new JBossStringBuilder().append("jdk5 throwable count: ").append(throwables5.size()).toString());
        CtorComparator compare = new CtorComparator();
        StringBuffer exceptionCtors = new StringBuffer();
        for (CtClass jdk14EX : throwables14.values()) {
            Object[] ctors5;
            Object[] ctors14;
            CtClass jdk5EX = throwables5.get(jdk14EX.getName());
            if (jdk5EX == null || (ctors14 = jdk14EX.getConstructors()).length == (ctors5 = jdk5EX.getConstructors()).length) continue;
            TreeSet jdk5Set = new TreeSet((Comparator)compare);
            jdk5Set.addAll((Collection)Arrays.asList((Object[])ctors5));
            List jdk14Set = Arrays.asList((Object[])ctors14);
            if (jdk14EX.getName().equals("java.lang.IllegalArgumentException")) {
                log.info(new JBossStringBuilder().append("jdk14(IllegalArgumentException): ").append(jdk14Set).toString());
                log.info(new JBossStringBuilder().append("jdk5(IllegalArgumentException): ").append(jdk5Set).toString());
            }
            jdk5Set.removeAll((Collection)jdk14Set);
            for (CtConstructor ctor : jdk5Set) {
                exceptionCtors.append("exceptionCtors.add(\"");
                exceptionCtors.append(ctor.getDeclaringClass().getName());
                exceptionCtors.append(ctor.getSignature());
                exceptionCtors.append("\"),\n");
            }
        }
        log.info(exceptionCtors.toString());
    }

    private static void scanJar(JarFile jar, ClassPool pool, CtClass langThrowable, HashMap<String, CtClass> throwables) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            name = name.replace('/', '.');
            name = name.substring(0, name.length() - 6);
            try {
                CtClass clazz = pool.get(name);
                if (!clazz.subtypeOf(langThrowable)) continue;
                throwables.put(name, clazz);
            }
            catch (NotFoundException e) {
                log.warning(e.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CtorComparator
    implements Comparator<CtConstructor> {
        CtorComparator() {
        }

        @Override
        public int compare(CtConstructor o1, CtConstructor o2) {
            String sig1 = o1.getSignature();
            String sig2 = o2.getSignature();
            return sig1.compareTo(sig2);
        }
    }
}

