/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang.javassist;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;
import org.jboss.lang.javassist.ScopedClassPool;

public class ScopedClassPoolRepository {
    private static final ScopedClassPoolRepository instance = new ScopedClassPoolRepository();
    private boolean prune = true;
    protected Map registeredCLs = Collections.synchronizedMap(new WeakHashMap());
    protected ClassPool classpool = ClassPool.getDefault();

    public static ScopedClassPoolRepository getInstance() {
        return instance;
    }

    private ScopedClassPoolRepository() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.classpool.insertClassPath((ClassPath)new LoaderClassPath(cl));
    }

    public boolean isPrune() {
        return this.prune;
    }

    public void setPrune(boolean prune) {
        this.prune = prune;
    }

    public ScopedClassPool createScopedClassPool(ClassLoader cl, ClassPool src) {
        return new ScopedClassPool(cl, src, this);
    }

    public ClassPool findClassPool(ClassLoader cl) {
        if (cl == null) {
            return this.registerClassLoader(ClassLoader.getSystemClassLoader());
        }
        return this.registerClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool registerClassLoader(ClassLoader ucl) {
        Map map = this.registeredCLs;
        synchronized (map) {
            if (this.registeredCLs.containsKey(ucl)) {
                return (ClassPool)this.registeredCLs.get(ucl);
            }
            ScopedClassPool pool = this.createScopedClassPool(ucl, this.classpool);
            this.registeredCLs.put(ucl, pool);
            return pool;
        }
    }

    public Map getRegisteredCLs() {
        this.clearUnregisteredClassLoaders();
        return this.registeredCLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnregisteredClassLoaders() {
        ArrayList toUnregister = null;
        Map map = this.registeredCLs;
        synchronized (map) {
            Iterator it = this.registeredCLs.values().iterator();
            while (it.hasNext()) {
                ScopedClassPool pool = (ScopedClassPool)((Object)it.next());
                if (!pool.isUnloadedClassLoader()) continue;
                it.remove();
            }
            if (toUnregister != null) {
                for (int i = 0; i < toUnregister.size(); ++i) {
                    this.unregisterClassLoader((ClassLoader)toUnregister.get(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClassLoader(ClassLoader cl) {
        Map map = this.registeredCLs;
        synchronized (map) {
            ScopedClassPool pool = (ScopedClassPool)((Object)this.registeredCLs.remove(cl));
            if (pool != null) {
                pool.close();
            }
        }
    }
}

