/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumImpl<E extends EnumImpl<E>>
implements Serializable,
Comparable<E> {
    private static final long serialVersionUID = 3760558672530976823L;
    private static WeakHashMap<Class, ArrayList> enumConstants = new WeakHashMap();
    private final String name;
    private final int ordinal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends EnumImpl<T>> T valueOf(Class<T> enumType, String name) {
        ArrayList enums;
        WeakHashMap<Class, ArrayList> weakHashMap = enumConstants;
        synchronized (weakHashMap) {
            enums = enumConstants.get(enumType);
        }
        EnumImpl match = null;
        for (EnumImpl t : enums) {
            if (!t.name().equals(name)) continue;
            match = t;
            break;
        }
        return (T)match;
    }

    public static <T extends EnumImpl<T>> T[] values(Class<T> enumType) {
        ArrayList enums = enumConstants.get(enumType);
        EnumImpl[] values = null;
        if (enums != null) {
            values = (EnumImpl[])enums.toArray();
        }
        return values;
    }

    static <T extends EnumImpl<T>> ArrayList<T> getEnumConstants(Class<T> enumType) {
        return enumConstants.get(enumType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnumImpl(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
        WeakHashMap<Class, ArrayList> weakHashMap = enumConstants;
        synchronized (weakHashMap) {
            ArrayList<EnumImpl> enums = enumConstants.get(this.getClass());
            if (enums == null) {
                enums = new ArrayList<EnumImpl>();
                enumConstants.put(this.getClass(), enums);
            }
            enums.add(this);
        }
    }

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.ordinal;
    }

    @Override
    public final int compareTo(E o) {
        return ((EnumImpl)o).ordinal - this.ordinal;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("An Enum is not cloneable!");
    }

    public final Class<E> getDeclaringClass() {
        Class<?> thisClass = this.getClass();
        Class<?> superClass = thisClass.getSuperclass();
        if (superClass == Class.forName("org.jboss.lang.EnumImpl")) {
            return thisClass;
        }
        return superClass;
    }
}

