/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.lang.EnumImpl;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.lang.reflect.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRedirects {
    private static final int SYNTHETIC = 4096;

    public static boolean isEnum(Class clazz) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        if (Class.forName("org.jboss.lang.EnumImpl") == clazz.getSuperclass()) {
            return true;
        }
        return superClass.getName().equals("java.lang.Enum");
    }

    public static <T extends EnumImpl<T>> T[] getEnumConstants(Class<T> enumType) {
        ArrayList<Object> list = EnumImpl.getEnumConstants(enumType);
        Object[] array = (Object[])Array.newInstance(enumType, list.size());
        return (EnumImpl[])list.toArray(array);
    }

    public static <T> T cast(Class<T> clazz, Object o) {
        if (o != null && !clazz.isInstance(o)) {
            throw new ClassCastException(new JBossStringBuilder().append("Expected ").append(clazz.getName()).append(" got ").append(o.getClass().getName()).toString());
        }
        return (T)o;
    }

    public static <T> Class<? extends T> asSubclass(Class<T> clazz, Class thisClazz) {
        if (clazz.isAssignableFrom(thisClazz)) {
            return thisClazz;
        }
        throw new ClassCastException(new JBossStringBuilder().append("Expected ").append(clazz.getName()).append(" got ").append(thisClazz.getName()).toString());
    }

    public static String replace(String string, CharSequence target, CharSequence replacement) {
        Pattern pattern = Pattern.compile(((Object)target).toString(), 16);
        Matcher matcher = pattern.matcher(string);
        String quotedReplacement = ClassRedirects.quoteReplacement(((Object)replacement).toString());
        return matcher.replaceAll(quotedReplacement);
    }

    public static boolean contains(String string, CharSequence s) {
        return string.indexOf(((Object)s).toString()) != -1;
    }

    public static String quoteReplacement(String string) {
        JBossStringBuilder builder = new JBossStringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (c == '$') {
                builder.append("\\$");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String getSimpleName(Class clazz) {
        int dollar;
        boolean isArray = clazz.isArray();
        if (isArray) {
            String arrayName = new JBossStringBuilder().append(ClassRedirects.getSimpleName(clazz.getComponentType())).append("[]").toString();
            return arrayName;
        }
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0 && (dollar = (name = name.substring(dot + 1)).lastIndexOf(36)) >= 0) {
            int index;
            name = name.substring(dollar + 1);
            for (index = 0; index < name.length() && Character.isDigit(name.charAt(index)); ++index) {
            }
            if (index > 0) {
                name = name.substring(index);
            }
        }
        return name;
    }

    public static String getCanonicalName(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            String string = null;
            string = ClassRedirects.getCanonicalName(clazz2);
            String name = string;
            if (name != null) {
                name = new JBossStringBuilder().append(name).append("[]").toString();
            }
            return name;
        }
        String name = null;
        if (!ClassRedirects.isAnonymousClass(clazz)) {
            name = clazz.getName();
            name = name.replace('$', '.');
        }
        return name;
    }

    public static boolean isAnonymousClass(Class clazz) {
        String name = ClassRedirects.getSimpleName(clazz);
        return name.length() == 0;
    }

    public static boolean isSynthetic(Class clazz) {
        throw new UnsupportedOperationException("isSynthetic is a TODO");
    }

    public static boolean isLocalClass(Class clazz) {
        throw new UnsupportedOperationException("isLocalClass is a TODO");
    }

    public static boolean isMemberClass(Class clazz) {
        throw new UnsupportedOperationException("isMemberClass is a TODO");
    }

    public static <T> TypeVariable<Class<T>>[] getTypeParameters(Class clazz) {
        throw new UnsupportedOperationException("getTypeParameters is a TODO");
    }

    public static Type getGenericSuperclass(Class clazz) {
        throw new UnsupportedOperationException("getGenericSuperclass is a TODO");
    }

    public static Type[] getGenericInterfaces(Class clazz) {
        throw new UnsupportedOperationException("getGenericInterfaces is a TODO");
    }

    public static Method getEnclosingMethod(Class clazz) {
        throw new UnsupportedOperationException("getEnclosingMethod cannot be implemented");
    }

    public static Constructor<?> getEnclosingConstructor(Class clazz) {
        throw new UnsupportedOperationException("getEnclosingConstructor cannot be implemented");
    }

    public static Class<?> getEnclosingClass(Class clazz) {
        throw new UnsupportedOperationException("getEnclosingClass cannot be implemented");
    }

    private ClassRedirects() {
    }
}

