/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.eviction.BaseEvictionPolicy;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionTimerTask;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.eviction.RegionNameConflictException;
import org.jgroups.View;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LRUPolicy
extends BaseEvictionPolicy
implements TreeCacheListener {
    protected Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$LRUPolicy == null ? (class$org$jboss$cache$eviction$LRUPolicy = LRUPolicy.class$("org.jboss.cache.eviction.LRUPolicy")) : class$org$jboss$cache$eviction$LRUPolicy));
    static final int WAKEUP_DEFAULT = 5;
    static final String ATTR = "attribute";
    static final String NAME = "name";
    static final Fqn ROOT = new Fqn("/");
    private int wakeUpIntervalSeconds_;
    private RegionValue[] regionValues_;
    private Timer timer_;
    static /* synthetic */ Class class$org$jboss$cache$eviction$LRUPolicy;

    public void nodeAdded(Fqn fqn) {
        if (fqn.equals(ROOT)) {
            return;
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("nodeAdded(): fqn- " + fqn));
        }
        Region region = this.regionManager_.getRegion(fqn.toString());
        region.setAddedNode(fqn);
    }

    public void nodeRemoved(Fqn fqn) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("nodeRemoved(): fqn- " + fqn));
        }
        Region region = this.regionManager_.getRegion(fqn.toString());
        region.setRemovedNode(fqn);
    }

    public void nodeEvicted(Fqn fqn) {
    }

    public void nodeModified(Fqn fqn) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("nodeModified(): redirecting to node visited. fqn- " + fqn));
        }
        this.nodeVisited(fqn);
    }

    public void nodeLoaded(Fqn fqn) {
    }

    public void nodeCreated(Fqn fqn) {
        this.nodeAdded(fqn);
    }

    public void nodeVisited(Fqn fqn) {
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("nodeVisited(): fqn- " + fqn));
        }
        Region region = this.regionManager_.getRegion(fqn.toString());
        region.setVisitedNode(fqn);
    }

    public void cacheStarted(TreeCache cache) {
        this.log_.info((Object)("Starting eviction policy using the provider: " + this.getClass().getName()));
        this.log_.info((Object)("Starting a eviction timer with wake up interval of (secs) " + this.wakeUpIntervalSeconds_));
        this.timer_ = new Timer();
        this.timer_.schedule((TimerTask)new EvictionTimerTask(this), this.wakeUpIntervalSeconds_ * 1000, (long)(this.wakeUpIntervalSeconds_ * 1000));
    }

    protected EvictionAlgorithm getEvictionAlgorithm() {
        return new LRUAlgorithm();
    }

    private void parseConfig(Element elem) {
        String REGION = "region";
        this.wakeUpIntervalSeconds_ = Integer.parseInt(this.getAttr(elem, "wakeUpIntervalSeconds"));
        if (this.wakeUpIntervalSeconds_ <= 0) {
            this.wakeUpIntervalSeconds_ = 5;
        }
        NodeList list = elem.getElementsByTagName(REGION);
        this.regionValues_ = new RegionValue[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            RegionValue val = new RegionValue();
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                String name;
                Element element = (Element)node;
                val.name_ = name = element.getAttribute(NAME);
                val.maxNodes_ = Integer.parseInt(this.getAttr(element, "maxNodes"));
                String timeToLive = this.getAttr(element, "timeToIdleSeconds");
                if (timeToLive == null && (timeToLive = this.getAttr(element, "timeToLiveSeconds")) == null) {
                    throw new RuntimeException("LRUPolicy.parseConfig(): Null timeToLiveSeconds element");
                }
                val.timeToLiveSeconds_ = Integer.parseInt(timeToLive);
                String maxAge = this.getAttr(element, "maxAgeSeconds");
                if (maxAge != null && !maxAge.equals("")) {
                    val.maxAgeSeconds_ = Integer.parseInt(maxAge);
                }
                if (this.log_.isDebugEnabled()) {
                    this.log_.debug((Object)("parseConfig: name -- " + name + " maxNodes -- " + val.maxNodes_ + " timeToLiveSeconds -- " + val.timeToLiveSeconds_ + " maxAgeSeconds -- " + val.maxAgeSeconds_));
                }
                this.regionValues_[i] = val;
            }
            ++i;
        }
    }

    private String getAttr(Element elem, String myName) {
        NodeList list = elem.getElementsByTagName(ATTR);
        int s = 0;
        while (s < list.getLength()) {
            Element element;
            String name;
            Node node = list.item(s);
            if (node.getNodeType() == 1 && (name = (element = (Element)node).getAttribute(NAME)).equals(myName)) {
                String valueStr = this.getElementContent(element, true);
                return valueStr;
            }
            ++s;
        }
        return null;
    }

    private String getElementContent(Element element, boolean trim) {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Text) {
                attributeText = attributeText + ((Text)n).getData();
            }
            ++i;
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        return attributeText;
    }

    public void cacheStopped(TreeCache cache) {
        this.log_.info((Object)"Stopping eviction policy timer ... ");
        this.timer_.cancel();
    }

    public void viewChange(View new_view) {
    }

    public int getWakeupIntervalSeconds() {
        return this.wakeUpIntervalSeconds_;
    }

    public void configure(TreeCache cache) {
        this.cache_ = cache;
        Element elem = cache.getEvictionPolicyConfig();
        this.parseConfig(elem);
        this.regionManager_ = new RegionManager(this);
        int i = 0;
        while (i < this.regionValues_.length) {
            EvictionAlgorithm algo = this.getEvictionAlgorithm();
            try {
                Region region = this.regionManager_.createRegion(this.regionValues_[i].name_, algo);
                region.setMaxNodes(this.regionValues_[i].maxNodes_);
                region.setTimeToLiveSeconds(this.regionValues_[i].timeToLiveSeconds_);
                region.setMaxAgeSeconds(this.regionValues_[i].maxAgeSeconds_);
            }
            catch (RegionNameConflictException e) {
                throw new RuntimeException("LRUPolicy.cacheStarted(): illegal region name specified for eviction policy  exception: " + (Object)((Object)e));
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RegionValue {
        String name_;
        int maxNodes_;
        int timeToLiveSeconds_;
        int maxAgeSeconds_;

        RegionValue() {
        }
    }
}

