/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.BaseInterceptor;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.util.AopUtil;

public class CacheInterceptor
implements BaseInterceptor {
    protected static Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$aop$CacheInterceptor == null ? (class$org$jboss$cache$aop$CacheInterceptor = CacheInterceptor.class$("org.jboss.cache.aop.CacheInterceptor")) : class$org$jboss$cache$aop$CacheInterceptor));
    TreeCacheAop cache;
    CachedType type;
    protected Fqn fqn;
    boolean checkSerialization;
    static Method writeExternal;
    static Method readExternal;
    static /* synthetic */ Class class$org$jboss$cache$aop$CacheInterceptor;
    static /* synthetic */ Class class$java$io$ObjectOutput;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$io$ObjectInput;
    static /* synthetic */ Class class$org$jboss$cache$aop$WriteReplaceable;
    static /* synthetic */ Class class$java$lang$Object;

    public CacheInterceptor(TreeCacheAop cache, Fqn fqn, CachedType type) {
        this.cache = cache;
        this.fqn = fqn;
        this.type = type;
        this.checkSerialization = !(class$org$jboss$cache$aop$WriteReplaceable == null ? (class$org$jboss$cache$aop$WriteReplaceable = CacheInterceptor.class$("org.jboss.cache.aop.WriteReplaceable")) : class$org$jboss$cache$aop$WriteReplaceable).isAssignableFrom(type.getType());
    }

    public String getName() {
        return "CacheInterceptor on [" + this.fqn + "]";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isPojoDetached(invocation)) {
            return invocation.invokeNext();
        }
        if (invocation instanceof FieldWriteInvocation) {
            FieldWriteInvocation fieldInvocation = (FieldWriteInvocation)invocation;
            Field field = fieldInvocation.getField();
            if (!CachedType.isNonReplicatable(field)) {
                CachedType fieldType = this.cache.getCachedType(field.getType());
                Object value = fieldInvocation.getValue();
                if (fieldType.isImmediate()) {
                    this.cache.put(this.fqn, (Object)field.getName(), value);
                } else {
                    this.cache.putObject(new Fqn(this.fqn, field.getName()), value);
                }
            }
        } else if (invocation instanceof FieldReadInvocation) {
            FieldReadInvocation fieldInvocation = (FieldReadInvocation)invocation;
            Field field = fieldInvocation.getField();
            if (!CachedType.isNonReplicatable(field)) {
                CachedType fieldType = this.cache.getCachedType(field.getType());
                Object result = fieldType.isImmediate() ? this.cache.get(this.fqn, (Object)field.getName()) : this.cache.getObject(new Fqn(this.fqn, field.getName()));
                if (result != null) {
                    return result;
                }
                Object value = invocation.getTargetObject();
                if (value == null || field.get(value) == null) {
                    return null;
                }
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("invoke(): DataNode on fqn: " + this.fqn + " has obviously been evicted. Will need to reconstruct it"));
                }
                this.cache.putObject(this.fqn, value);
            }
        } else if (this.checkSerialization) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            Method method = methodInvocation.getMethod();
            if (method != null && method.getName().equals("writeReplace") && method.getReturnType().equals(class$java$lang$Object == null ? (class$java$lang$Object = CacheInterceptor.class$("java.lang.Object")) : class$java$lang$Object) && method.getParameterTypes().length == 0) {
                this.beforeSerialization(invocation.getTargetObject());
            } else if (method == writeExternal) {
                Object target = methodInvocation.getTargetObject();
                this.beforeSerialization(target);
            }
        }
        return invocation.invokeNext();
    }

    protected boolean isPojoDetached(Invocation invocation) throws Exception {
        boolean detached = false;
        if (!this.cache.exists(this.fqn, (Object)"__jboss:internal:class__")) {
            detached = true;
            Object obj = invocation.getTargetObject();
            if (!(obj instanceof Advised)) {
                throw new RuntimeException("Interception on non-advised pojo " + obj.toString());
            }
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            CacheInterceptor interceptor = (CacheInterceptor)AopUtil.findCacheInterceptor(advisor);
            if (interceptor != null) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("isPojoDetached(): removed cache interceptor fqn: " + this.fqn + " interceptor: " + interceptor));
                }
                advisor.removeInterceptor(interceptor.getName());
            }
        }
        return detached;
    }

    protected void checkCacheConsistency() throws Exception {
        if (this != this.cache.peek(this.fqn, AOPInstance.KEY)) {
            new RuntimeException("Cache inconsistency: Outdated AOPInstance");
        }
    }

    public void beforeSerialization(Object target) throws Exception {
        Iterator i = this.type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            CachedType fieldType = this.cache.getCachedType(field.getType());
            Object value = null;
            value = fieldType.isImmediate() ? this.cache.get(this.fqn, (Object)field.getName()) : this.cache.getObject(new Fqn(this.fqn, field.getName()));
            field.set(target, value);
        }
    }

    boolean isChildOf(Fqn parentFqn) {
        return this.fqn.isChildOf(parentFqn);
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setFqn(Fqn fqn) {
        this.fqn = fqn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            writeExternal = (class$java$io$Externalizable == null ? (class$java$io$Externalizable = CacheInterceptor.class$("java.io.Externalizable")) : class$java$io$Externalizable).getMethod("writeExternal", class$java$io$ObjectOutput == null ? (class$java$io$ObjectOutput = CacheInterceptor.class$("java.io.ObjectOutput")) : class$java$io$ObjectOutput);
            readExternal = (class$java$io$Externalizable == null ? (class$java$io$Externalizable = CacheInterceptor.class$("java.io.Externalizable")) : class$java$io$Externalizable).getMethod("readExternal", class$java$io$ObjectInput == null ? (class$java$io$ObjectInput = CacheInterceptor.class$("java.io.ObjectInput")) : class$java$io$ObjectInput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

