/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class ValueBoxDecl
extends Value {
    private boolean written = false;
    private boolean parsed = false;
    TypeSpec typeSpec;

    public ValueBoxDecl(int num) {
        super(num);
        this.pack_name = "";
    }

    public Object clone() {
        return null;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        if (this.typeSpec.typeSpec() instanceof BaseType) {
            return this.typeName;
        }
        return this.typeSpec.typeSpec().typeName();
    }

    public String boxTypeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public boolean basic() {
        return false;
    }

    public void set_included(boolean i) {
        this.included = i;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.typeSpec.setPackage(s);
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            this.logger.error("was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public String toString() {
        return this.typeName();
    }

    public void parse() {
        if (this.parsed) {
            throw new RuntimeException("Compiler error: Value box already parsed!");
        }
        this.escapeName();
        this.typeSpec.parse();
        try {
            ConstrTypeSpec ctspec = new ConstrTypeSpec(ValueBoxDecl.new_num());
            ctspec.c_type_spec = this;
            NameTable.define(this.full_name(), "type");
            TypeMap.typedef(this.full_name(), ctspec);
        }
        catch (NameAlreadyDefined nad) {
            parser.error("Value box " + this.typeName() + " already defined", this.token);
        }
        this.parsed = true;
    }

    public String className() {
        String fullName = this.typeName();
        if (fullName.indexOf(46) > 0) {
            return fullName.substring(fullName.lastIndexOf(46) + 1);
        }
        return fullName;
    }

    public String printReadExpression(String streamname) {
        return "(" + this.typeName() + ")((org.omg.CORBA_2_3.portable.InputStream)" + streamname + ").read_value (new " + this.helperName() + "())";
    }

    public String printWriteStatement(String var_name, String streamname) {
        return "((org.omg.CORBA_2_3.portable.OutputStream)" + streamname + ").write_value (" + var_name + ", new " + this.helperName() + "());";
    }

    public String holderName() {
        return this.boxTypeName() + "Holder";
    }

    public String helperName() {
        return this.boxTypeName() + "Helper";
    }

    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        knownTypes.add(this);
        StringBuffer sb = new StringBuffer();
        String className = this.boxTypeName();
        if (className.indexOf(46) > 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        sb.append("org.omg.CORBA.ORB.init().create_value_box_tc(" + this.helperName() + ".id(),\"" + className + "\"," + this.typeSpec.typeSpec().getTypeCodeExpression() + ")");
        return sb.toString();
    }

    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + this.typeName() + " value;\n");
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + this.typeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.helperName() + ".type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + this.helperName() + ".read (_in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + this.helperName() + ".write (_out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("\timplements org.omg.CORBA.portable.BoxedValueHelper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        String type = this.typeName();
        TypeSpec.printHelperClassMethods(ps, type);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        if (this.typeSpec.typeSpec() instanceof BaseType) {
            ps.println("\t\t" + type + " result = new " + type + "(" + this.typeSpec.typeSpec().printReadExpression("in") + ");");
        } else {
            ps.println("\t\t" + type + " result;");
            ps.println("\t\t" + this.typeSpec.typeSpec().printReadStatement("result", "in"));
        }
        ps.println("\t\treturn result;");
        ps.println("\t}");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        ps.println("\t{");
        if (this.typeSpec.typeSpec() instanceof BaseType) {
            ps.println("\t\t" + this.typeSpec.typeSpec().printWriteStatement("s.value", "out"));
        } else {
            ps.println("\t\t" + this.typeSpec.typeSpec().printWriteStatement("s", "out"));
        }
        ps.println("\t}");
        ps.println("\tpublic java.io.Serializable read_value (final org.omg.CORBA.portable.InputStream is)");
        ps.println("\t{");
        ps.println("\t\treturn " + this.helperName() + ".read (is);");
        ps.println("\t}");
        ps.println("\tpublic void write_value (final org.omg.CORBA.portable.OutputStream os, final java.io.Serializable value)");
        ps.println("\t{");
        ps.println("\t\t" + this.helperName() + ".write (os, (" + type + ")value);");
        ps.println("\t}");
        ps.println("\tpublic java.lang.String get_id()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.helperName() + ".id();");
        ps.println("\t}");
        ps.println("}");
    }

    private void printValueClass(String className, PrintWriter ps) {
        String fullClassName = className;
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            fullClassName = this.pack_name + "." + className;
            ps.println("package " + this.pack_name + ";");
        }
        ps.println("public class " + className);
        ps.println("\timplements org.omg.CORBA.portable.ValueBase");
        ps.println("{");
        ps.println("\tpublic " + this.typeSpec.typeName() + " value;");
        ps.println("\tprivate static String[] _ids = { " + className + "Helper.id() };");
        ps.println("\tpublic " + className + "(" + this.typeSpec.typeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic String[] _truncatable_ids()");
        ps.println("\t{");
        ps.println("\t\treturn _ids;");
        ps.println("\t}");
        ps.println("}");
    }

    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written) {
            try {
                PrintWriter decl_ps;
                String path;
                File dir;
                String className = this.boxTypeName();
                if (className.indexOf(46) > 0) {
                    className = className.substring(className.lastIndexOf(46) + 1);
                }
                if (!(dir = new File(path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator))).exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                String fname = className + ".java";
                File f = new File(dir, fname);
                if (this.typeSpec.typeSpec() instanceof BaseType && GlobalInputStream.isMoreRecentThan(f)) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printValueClass(className, decl_ps);
                    decl_ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, decl_ps);
                    decl_ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    decl_ps = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, decl_ps);
                    decl_ps.close();
                }
                this.written = true;
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + ".type(" + this.getTypeCodeExpression() + ");");
        ps.println("\t\t" + this.helperName() + ".write(" + anyname + ".create_output_stream()," + varname + ");");
    }

    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = (" + resulttype + ")" + anyname + ".extract_Value();");
    }

    public void accept(IDLTreeVisitor visitor) {
        visitor.visitValue(this);
    }
}

