/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Set;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Member;
import org.jacorb.idl.MemberList;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class StructType
extends TypeDeclaration
implements Scope {
    private boolean written = false;
    public boolean exc;
    public MemberList memberlist = null;
    private boolean parsed = false;
    private ScopeData scopeData;

    public StructType(int num) {
        super(num);
        this.pack_name = "";
    }

    public void setScopeData(ScopeData data) {
        this.scopeData = data;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public boolean isException() {
        return this.exc;
    }

    public Object clone() {
        StructType st = new StructType(StructType.new_num());
        st.pack_name = this.pack_name;
        st.name = this.name;
        st.memberlist = this.memberlist;
        st.included = this.included;
        st.token = this.token;
        st.exc = this.exc;
        st.scopeData = this.scopeData;
        st.enclosing_symbol = this.enclosing_symbol;
        return st;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public String getJavaTypeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public String getIDLTypeName() {
        return this.getJavaTypeName();
    }

    public boolean basic() {
        return false;
    }

    public void set_memberlist(MemberList m) {
        m.setContainingType(this);
        this.memberlist = m;
        this.memberlist.setPackage(this.name);
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    public void set_included(boolean i) {
        this.included = i;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.memberlist != null) {
            this.memberlist.setPackage(s);
        }
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            this.logger.error("was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    public String toString() {
        return this.typeName();
    }

    public void parse() {
        boolean justAnotherOne = false;
        if (this.parsed) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parsing Struct " + this.name);
        }
        this.escapeName();
        ConstrTypeSpec ctspec = new ConstrTypeSpec(StructType.new_num());
        try {
            ScopedName.definePseudoScope(this.full_name());
            ctspec.c_type_spec = this;
            NameTable.define(this.full_name(), "type-struct");
            TypeMap.typedef(this.full_name(), ctspec);
        }
        catch (NameAlreadyDefined nad) {
            if (this.exc) {
                parser.error("Struct " + this.getJavaTypeName() + " already defined", this.token);
            }
            if (parser.get_pending(this.full_name()) != null) {
                if (this.memberlist != null) {
                    justAnotherOne = true;
                }
                if (!this.full_name().equals("org.omg.CORBA.TypeCode") && this.memberlist != null) {
                    TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
                }
            }
            parser.error("Struct " + this.getJavaTypeName() + " already defined", this.token);
        }
        if (this.memberlist != null) {
            ScopedName.addRecursionScope(this.getJavaTypeName());
            this.memberlist.parse();
            ScopedName.removeRecursionScope(this.getJavaTypeName());
            if (!this.exc) {
                NameTable.parsed_interfaces.put(this.full_name(), "");
                parser.remove_pending(this.full_name());
            }
        } else if (!justAnotherOne && !this.exc) {
            parser.set_pending(this.full_name());
        }
        this.parsed = true;
    }

    public String className() {
        String fullName = this.getJavaTypeName();
        if (fullName.indexOf(46) > 0) {
            return fullName.substring(fullName.lastIndexOf(46) + 1);
        }
        return fullName;
    }

    public String printReadExpression(String Streamname) {
        return this.toString() + "Helper.read(" + Streamname + ")";
    }

    public String printWriteStatement(String var_name, String streamname) {
        return this.toString() + "Helper.write(" + streamname + "," + var_name + ");";
    }

    public String holderName() {
        return this.getJavaTypeName() + "Holder";
    }

    public String helperName() {
        return this.getJavaTypeName() + "Helper";
    }

    public String getTypeCodeExpression() {
        return this.full_name() + "Helper.type()";
    }

    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        return this.getTypeCodeExpression();
    }

    private void printClassComment(String className, PrintWriter ps) {
        ps.println("/**");
        ps.println(" *\tGenerated from IDL definition of " + (this.exc ? "exception " : "struct ") + "\"" + className + "\"");
        ps.println(" *\t@author JacORB IDL compiler ");
        ps.println(" */\n");
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment(className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + this.getJavaTypeName() + " value;\n");
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder(final " + this.getJavaTypeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.getJavaTypeName() + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read(final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + this.getJavaTypeName() + "Helper.read(_in);");
        ps.println("\t}");
        ps.println("\tpublic void _write(final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + this.getJavaTypeName() + "Helper.write(_out, value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        Declarator d;
        Member m;
        Enumeration e;
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";\n");
        }
        this.printImport(ps);
        this.printClassComment(className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = null;");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        ps.println("\t{");
        ps.println("\t\tif (_type == null)");
        ps.println("\t\t{");
        StringBuffer sb = new StringBuffer();
        sb.append("org.omg.CORBA.ORB.init().create_" + (this.exc ? "exception" : "struct") + "_tc(" + this.getJavaTypeName() + "Helper.id(),\"" + this.className() + "\",");
        if (this.memberlist != null) {
            sb.append("new org.omg.CORBA.StructMember[]{");
            Enumeration e2 = this.memberlist.v.elements();
            while (e2.hasMoreElements()) {
                Member m2 = (Member)e2.nextElement();
                Declarator d2 = m2.declarator;
                sb.append("new org.omg.CORBA.StructMember(\"" + d2.name() + "\", ");
                sb.append(m2.type_spec.typeSpec().getTypeCodeExpression());
                sb.append(", null)");
                if (!e2.hasMoreElements()) continue;
                sb.append(",");
            }
            sb.append("}");
        } else {
            sb.append("new org.omg.CORBA.StructMember[0]");
        }
        sb.append(")");
        ps.println("\t\t\t_type = " + sb.toString() + ";");
        ps.println("\t\t}");
        ps.println("\t\treturn _type;");
        ps.println("\t}\n");
        String type = this.getJavaTypeName();
        TypeSpec.printInsertExtractMethods(ps, type);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\t" + type + " result = new " + type + "();");
        if (this.exc) {
            ps.println("\t\tif (!in.read_string().equals(id())) throw new org.omg.CORBA.MARSHAL(\"wrong id\");");
        }
        if (this.memberlist != null) {
            e = this.memberlist.v.elements();
            while (e.hasMoreElements()) {
                m = (Member)e.nextElement();
                d = m.declarator;
                ps.println("\t\t" + m.type_spec.typeSpec().printReadStatement("result." + d.name(), "in"));
            }
        }
        ps.println("\t\treturn result;");
        ps.println("\t}");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        ps.println("\t{");
        if (this.exc) {
            ps.println("\t\tout.write_string(id());");
        }
        if (this.memberlist != null) {
            e = this.memberlist.v.elements();
            while (e.hasMoreElements()) {
                m = (Member)e.nextElement();
                d = m.declarator;
                ps.println("\t\t" + m.type_spec.typeSpec().printWriteStatement("s." + d.name(), "out"));
            }
        }
        ps.println("\t}");
        ps.println("}");
    }

    private void printStructClass(String className, PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        String fullClassName = className;
        if (!this.pack_name.equals("")) {
            fullClassName = this.pack_name + "." + className;
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment(className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className);
        if (this.exc) {
            ps.println("\textends org.omg.CORBA.UserException");
        } else {
            ps.println("\timplements org.omg.CORBA.portable.IDLEntity");
        }
        ps.println("{");
        if (this.exc) {
            ps.println("\tpublic " + className + "()");
            ps.println("\t{");
            ps.println("\t\tsuper(" + fullClassName + "Helper.id());");
            ps.println("\t}");
            ps.println();
            if (this.memberlist == null) {
                ps.println("\tpublic " + className + "(String value)");
                ps.println("\t{");
                ps.println("\t\tsuper(value);");
                ps.println("\t}");
            }
        } else {
            ps.println("\tpublic " + className + "(){}");
        }
        if (this.memberlist != null) {
            Declarator d;
            Member m;
            Enumeration e = this.memberlist.v.elements();
            while (e.hasMoreElements()) {
                ((Member)e.nextElement()).member_print(ps, "\tpublic ");
                ps.println();
            }
            if (this.exc) {
                ps.print("\tpublic " + className + "(");
                ps.print("java.lang.String _reason,");
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    m = (Member)e.nextElement();
                    d = m.declarator;
                    ps.print(m.type_spec.toString() + " " + d.toString());
                    if (!e.hasMoreElements()) continue;
                    ps.print(", ");
                }
                ps.println(")");
                ps.println("\t{");
                ps.println("\t\tsuper(" + fullClassName + "Helper.id()+ \" \" + _reason);");
                e = this.memberlist.v.elements();
                while (e.hasMoreElements()) {
                    m = (Member)e.nextElement();
                    d = m.declarator;
                    ps.print("\t\tthis.");
                    ps.print(d.name());
                    ps.print(" = ");
                    ps.println(d.name() + ";");
                }
                ps.println("\t}");
            }
            ps.print("\tpublic " + className + "(");
            e = this.memberlist.v.elements();
            while (e.hasMoreElements()) {
                m = (Member)e.nextElement();
                d = m.declarator;
                ps.print(m.type_spec.toString() + " " + d.name());
                if (!e.hasMoreElements()) continue;
                ps.print(", ");
            }
            ps.println(")");
            ps.println("\t{");
            if (this.exc) {
                ps.println("\t\tsuper(" + fullClassName + "Helper.id());");
            }
            e = this.memberlist.v.elements();
            while (e.hasMoreElements()) {
                m = (Member)e.nextElement();
                d = m.declarator;
                ps.print("\t\tthis.");
                ps.print(d.name());
                ps.print(" = ");
                ps.println(d.name() + ";");
            }
            ps.println("\t}");
        }
        ps.println("}");
    }

    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (!this.parsed) {
            throw new ParseException("Unparsed Struct!");
        }
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written) {
            this.written = true;
            try {
                PrintWriter printWriter;
                String fname;
                File f;
                String className = this.className();
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + ".java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printStructClass(className, printWriter);
                    printWriter.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, printWriter);
                    printWriter.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, printWriter);
                    printWriter.close();
                }
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + this.pack_name + "." + this.className() + "Helper.insert(" + anyname + ", " + varname + ");");
    }

    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + this.pack_name + "." + this.className() + "Helper.extract(" + anyname + ");");
    }

    public void accept(IDLTreeVisitor visitor) {
        visitor.visitStruct(this);
    }
}

