/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IllegalRedefinition;
import org.jacorb.idl.InterfaceBody;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ReplyHandler;
import org.jacorb.idl.ReplyHandlerTypeSpec;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class Interface
extends TypeDeclaration
implements Scope {
    public InterfaceBody body = null;
    public SymbolList inheritanceSpec = null;
    private String[] ids = null;
    private boolean is_local = false;
    private boolean is_abstract = false;
    private ScopeData scopeData;
    private boolean parsed = false;
    private ReplyHandler replyHandler = null;
    private Hashtable irInfoTable = new Hashtable();
    protected static HashSet abstractInterfaces;

    public Interface(int num) {
        super(num);
        this.pack_name = "";
    }

    public void setScopeData(ScopeData data) {
        this.scopeData = data;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public void setPackage(String s) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Interface setPackage " + s);
        }
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.body != null) {
            this.body.setPackage(s);
        }
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setPackage(s);
        }
    }

    public void set_abstract() {
        this.is_abstract = true;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        return this.full_name();
    }

    public Object clone() {
        throw new RuntimeException("Don't clone me, i am an interface!");
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setEnclosingSymbol(s);
        }
    }

    public void set_locality(boolean local) {
        this.is_local = local;
    }

    public String getTypeCodeExpression() {
        if (this.is_abstract) {
            return "org.omg.CORBA.ORB.init().create_abstract_interface_tc(\"" + this.id() + "\", \"" + this.name + "\")";
        }
        return "org.omg.CORBA.ORB.init().create_interface_tc(\"" + this.id() + "\", \"" + this.name + "\")";
    }

    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        return this.getTypeCodeExpression();
    }

    public boolean basic() {
        return true;
    }

    public String holderName() {
        return this.toString() + "Holder";
    }

    public String helperName() {
        return this.toString() + "Helper";
    }

    public String toString() {
        String n = this.typeName();
        if (!n.startsWith("org.omg")) {
            return this.omgPrefix() + n;
        }
        return n;
    }

    public void set_included(boolean i) {
        this.included = i;
    }

    public String printReadExpression(String Streamname) {
        return this.javaName() + "Helper.read(" + Streamname + ")";
    }

    public String printWriteStatement(String var_name, String Streamname) {
        return this.javaName() + "Helper.write(" + Streamname + "," + var_name + ");";
    }

    public void parse() {
        boolean justAnotherOne;
        block22: {
            justAnotherOne = false;
            if (this.parsed) {
                return;
            }
            this.escapeName();
            ConstrTypeSpec ctspec = new ConstrTypeSpec(Interface.new_num());
            if (this.is_abstract) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding " + this.full_name() + " to abstract interface list");
                }
                if (abstractInterfaces == null) {
                    abstractInterfaces = new HashSet();
                }
                abstractInterfaces.add(this.full_name());
            }
            try {
                ScopedName.definePseudoScope(this.full_name());
                ctspec.c_type_spec = this;
                if (this.is_pseudo) {
                    NameTable.define(this.full_name(), "pseudo interface");
                } else {
                    NameTable.define(this.full_name(), "interface");
                }
                TypeMap.typedef(this.full_name(), ctspec);
            }
            catch (IllegalRedefinition ill) {
                parser.fatal_error("Illegal Redefinition of  " + ill.oldDef + " in nested scope as " + ill.newDef, this.token);
            }
            catch (NameAlreadyDefined nad) {
                if (parser.get_pending(this.full_name()) == null) break block22;
                if (this.body == null) {
                    justAnotherOne = true;
                }
                if (this.full_name().equals("org.omg.CORBA.TypeCode") || this.body == null) break block22;
                TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
            }
        }
        if (this.body != null) {
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking inheritanceSpec of " + this.full_name());
                }
                Hashtable<String, String> h = new Hashtable<String, String>();
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ConstrTypeSpec ts;
                    ScopedName name = (ScopedName)e.nextElement();
                    TypeSpec resolvedTSpec = name.resolvedTypeSpec();
                    while (resolvedTSpec instanceof AliasTypeSpec) {
                        resolvedTSpec = ((AliasTypeSpec)resolvedTSpec).originalType();
                    }
                    if (!(resolvedTSpec instanceof ConstrTypeSpec)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Illegal inheritance spec, not a constr. type but " + resolvedTSpec.getClass() + ", name " + name);
                        }
                        parser.fatal_error("Illegal inheritance spec (not a constr. type): " + this.inheritanceSpec, this.token);
                    }
                    if ((ts = (ConstrTypeSpec)resolvedTSpec).declaration() instanceof Interface) {
                        if (h.containsKey(ts.full_name())) {
                            parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec + " (repeated inheritance not allowed).", this.token);
                        }
                        h.put(ts.full_name(), "");
                        continue;
                    }
                    parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec + " (ancestor " + ts.full_name() + " not an interface)", this.token);
                }
                this.body.set_ancestors(this.inheritanceSpec);
            }
            this.body.parse();
            NameTable.parsed_interfaces.put(this.full_name(), "");
            if (parser.generate_ami_callback) {
                this.replyHandler = new ReplyHandler(this);
                this.replyHandler.parse();
            }
        } else if (!justAnotherOne) {
            parser.set_pending(this.full_name());
        }
        this.parsed = true;
    }

    InterfaceBody getBody() {
        if (parser.get_pending(this.full_name()) != null) {
            parser.fatal_error(this.full_name() + " is forward declared and still pending!", this.token);
        } else if (this.body == null) {
            if ((Interface)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec != this) {
                this.body = ((Interface)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec).getBody();
            }
            if (this.body == null) {
                parser.fatal_error(this.full_name() + " still has an empty body!", this.token);
            }
        }
        return this.body;
    }

    protected PrintWriter openOutput(String typeName) {
        String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            parser.fatal_error("Unable to create " + path, null);
        }
        try {
            File f = new File(dir, typeName + ".java");
            if (GlobalInputStream.isMoreRecentThan(f)) {
                PrintWriter ps = new PrintWriter(new FileWriter(f));
                return ps;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open output file for " + typeName + " (" + e + ")");
        }
    }

    protected void printPackage(PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + this.name + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";\n");
        }
    }

    protected void printClassComment(String className, PrintWriter ps) {
        ps.println("/**");
        ps.println(" *\tGenerated from IDL interface \"" + className + "\"");
        ps.println(" *\t@author JacORB IDL compiler V 2.2.3, 10-Dec-2005");
        ps.println(" */\n");
    }

    protected void printSuperclassImports(PrintWriter ps) {
        if (this.inheritanceSpec.v.size() > 0) {
            Enumeration e = this.inheritanceSpec.v.elements();
            while (e.hasMoreElements()) {
                ScopedName sn = (ScopedName)e.nextElement();
                if (sn.resolvedName().indexOf(46) >= 0) continue;
                ps.println("import " + sn + ";");
            }
        }
    }

    protected void printInterface() {
        PrintWriter ps;
        block14: {
            block13: {
                ps = this.openOutput(this.name);
                if (ps == null) {
                    return;
                }
                this.printPackage(ps);
                this.printClassComment(this.name, ps);
                this.printSuperclassImports(ps);
                if (!this.is_pseudo) break block13;
                ps.println("public abstract class " + this.name);
                if (this.inheritanceSpec.v.size() <= 0) break block14;
                StringBuffer pseudo_bases = new StringBuffer();
                StringBuffer regular_bases = new StringBuffer();
                String comma = " ";
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ScopedName sn = (ScopedName)e.nextElement();
                    String name = sn.resolvedName();
                    if (sn.is_pseudo()) {
                        pseudo_bases.append(comma + name);
                    } else {
                        regular_bases.append(comma + name);
                    }
                    if (this.inheritanceSpec.v.size() <= 1) continue;
                    comma = ",";
                }
                if (pseudo_bases.length() > 0) {
                    ps.println("\textends " + pseudo_bases.toString());
                }
                if (regular_bases.length() <= 0) break block14;
                ps.println("\timplements " + regular_bases.toString());
                break block14;
            }
            ps.println("public interface " + this.name);
            if (this.is_abstract) {
                ps.print("\textends org.omg.CORBA.portable.IDLEntity");
            } else {
                ps.print("\textends " + this.name + "Operations");
                if (this.is_local) {
                    ps.print(", org.omg.CORBA.LocalInterface, org.omg.CORBA.portable.IDLEntity");
                } else {
                    ps.print(", org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity");
                }
            }
            if (this.inheritanceSpec.v.size() > 0) {
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ps.print(", " + (ScopedName)e.nextElement());
                }
            }
        }
        ps.println("\n{");
        if (this.body != null) {
            this.body.printInterfaceMethods(ps);
            if (this.is_abstract) {
                this.body.printConstants(ps);
                this.body.printOperationSignatures(ps);
            }
        }
        ps.println("}");
        ps.close();
    }

    protected void printOperations() {
        PrintWriter ps = this.openOutput(this.name + "Operations");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printClassComment(this.name, ps);
        this.printSuperclassImports(ps);
        this.printImport(ps);
        ps.println("public interface " + this.name + "Operations");
        if (this.inheritanceSpec.v.size() > 0) {
            ps.print("\textends ");
            Enumeration e = this.inheritanceSpec.v.elements();
            do {
                ScopedName sne = (ScopedName)e.nextElement();
                if (abstractInterfaces != null && abstractInterfaces.contains(sne.toString())) {
                    ps.print(sne);
                } else {
                    ps.print(sne + "Operations");
                }
                if (!e.hasMoreElements()) continue;
                ps.print(" , ");
            } while (e.hasMoreElements());
            ps.print("\n");
        }
        ps.println("{");
        if (this.body != null) {
            this.body.printConstants(ps);
            this.body.printOperationSignatures(ps);
        }
        ps.println("}");
        ps.close();
    }

    protected void printHolder() {
        PrintWriter ps = this.openOutput(this.name + "Holder");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printClassComment(this.name, ps);
        ps.print("public" + parser.getFinalString() + " class " + this.name + "Holder");
        ps.print("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\t public " + this.name + " value;");
        ps.println("\tpublic " + this.name + "Holder()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "Holder (final " + this.name + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.name + "Helper.type();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + this.name + "Helper.read (in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + this.name + "Helper.write (_out,value);");
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printHelper() {
        String stub_name;
        PrintWriter ps = this.openOutput(this.name + "Helper");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printImport(ps);
        this.printClassComment(this.name, ps);
        ps.println("public" + parser.getFinalString() + " class " + this.name + "Helper");
        ps.println("{");
        ps.println("\tpublic static void insert (final org.omg.CORBA.Any any, final " + this.typeName() + " s)");
        ps.println("\t{");
        if (this.is_abstract) {
            ps.println("\t\tif (s instanceof org.omg.CORBA.Object)");
            ps.println("\t\t{");
            ps.println("\t\t\tany.insert_Object((org.omg.CORBA.Object)s);");
            ps.println("\t\t}");
            ps.println("\t\telse if (s instanceof java.io.Serializable)");
            ps.println("\t\t{");
            ps.println("\t\t\tany.insert_Value((java.io.Serializable)s);");
            ps.println("\t\t}");
            ps.println("\t\telse");
            ps.println("\t\t{");
            ps.println("\t\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Failed to insert in helper\");");
            ps.println("\t\t}");
        } else {
            ps.println("\t\t\tany.insert_Object(s);");
        }
        ps.println("\t}");
        ps.println("\tpublic static " + this.typeName() + " extract(final org.omg.CORBA.Any any)");
        ps.println("\t{");
        if (this.is_abstract) {
            ps.println("\t\ttry");
            ps.println("\t\t{");
            ps.println("\t\t\treturn narrow(any.extract_Object());");
            ps.println("\t\t}");
            ps.println("\t\tcatch (org.omg.CORBA.BAD_OPERATION ex)");
            ps.println("\t\t{");
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\treturn (" + this.typeName() + ")any.extract_Value();");
            ps.println("\t\t\t}");
            ps.println("\t\t\tcatch (ClassCastException e)");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\tthrow new org.omg.CORBA.MARSHAL(e.getMessage());");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
        } else if (parser.useUncheckedNarrow) {
            ps.println("\t\treturn unchecked_narrow(any.extract_Object());");
        } else {
            ps.println("\t\treturn narrow(any.extract_Object()) ;");
        }
        ps.println("\t}");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.getTypeCodeExpression() + ";");
        ps.println("\t}");
        this.printIdMethod(ps);
        ps.println("\tpublic static " + this.name + " read(final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        if (this.is_local) {
            ps.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
        } else if (this.is_abstract) {
            ps.println("\t\treturn narrow(((org.omg.CORBA_2_3.portable.InputStream)in).read_abstract_interface());");
        } else if (parser.useUncheckedNarrow) {
            ps.println("\t\treturn unchecked_narrow(in.read_Object());");
        } else {
            ps.println("\t\treturn narrow(in.read_Object());");
        }
        ps.println("\t}");
        ps.println("\tpublic static void write(final org.omg.CORBA.portable.OutputStream _out, final " + this.typeName() + " s)");
        ps.println("\t{");
        if (this.is_local) {
            ps.println("\t\tthrow new org.omg.CORBA.MARSHAL();");
        } else if (this.is_abstract) {
            ps.println("\t\t((org.omg.CORBA_2_3.portable.OutputStream)_out).write_abstract_interface(s);");
        } else {
            ps.println("\t\t_out.write_Object(s);");
        }
        ps.println("\t}");
        ps.println("\tpublic static " + this.typeName() + " narrow(final java.lang.Object obj)");
        ps.println("\t{");
        ps.println("\t\tif (obj instanceof " + this.typeName() + ')');
        ps.println("\t\t{");
        ps.println("\t\t\treturn (" + this.typeName() + ")obj;");
        ps.println("\t\t}");
        ps.println("\t\telse if (obj instanceof org.omg.CORBA.Object)");
        ps.println("\t\t{");
        ps.println("\t\t\treturn narrow((org.omg.CORBA.Object)obj);");
        ps.println("\t\t}");
        ps.println("\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Failed to narrow in helper\");");
        ps.println("\t}");
        ps.println("\tpublic static " + this.typeName() + " narrow(final org.omg.CORBA.Object obj)");
        ps.println("\t{");
        ps.println("\t\tif (obj == null)");
        ps.println("\t\t\treturn null;");
        if (parser.generate_stubs && !this.is_local) {
            ps.println("\t\ttry");
            ps.println("\t\t{");
            ps.println("\t\t\treturn (" + this.typeName() + ")obj;");
            ps.println("\t\t}");
            ps.println("\t\tcatch (ClassCastException c)");
            ps.println("\t\t{");
            ps.println("\t\t\tif (obj._is_a(\"" + this.id() + "\"))");
            ps.println("\t\t\t{");
            stub_name = this.typeName();
            stub_name = stub_name.indexOf(46) > -1 ? stub_name.substring(0, this.typeName().lastIndexOf(46)) + "._" + stub_name.substring(stub_name.lastIndexOf(46) + 1) + "Stub" : "_" + stub_name + "Stub";
            ps.println("\t\t\t\t" + stub_name + " stub;");
            ps.println("\t\t\t\tstub = new " + stub_name + "();");
            ps.println("\t\t\t\tstub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
            ps.println("\t\t\t\treturn stub;");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
            ps.println("\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Narrow failed\");");
        } else {
            ps.println("\t\tif (obj instanceof " + this.typeName() + ")");
            ps.println("\t\t\treturn (" + this.typeName() + ")obj;");
            ps.println("\t\telse");
            ps.println("\t\tthrow new org.omg.CORBA.BAD_PARAM(\"Narrow failed, not a " + this.typeName() + "\");");
        }
        ps.println("\t}");
        ps.println("\tpublic static " + this.typeName() + " unchecked_narrow(final org.omg.CORBA.Object obj)");
        ps.println("\t{");
        ps.println("\t\tif (obj == null)");
        ps.println("\t\t\treturn null;");
        if (parser.generate_stubs && !this.is_local) {
            ps.println("\t\ttry");
            ps.println("\t\t{");
            ps.println("\t\t\treturn (" + this.typeName() + ")obj;");
            ps.println("\t\t}");
            ps.println("\t\tcatch (ClassCastException c)");
            ps.println("\t\t{");
            stub_name = this.typeName();
            stub_name = stub_name.indexOf(46) > -1 ? stub_name.substring(0, this.typeName().lastIndexOf(46)) + "._" + stub_name.substring(stub_name.lastIndexOf(46) + 1) + "Stub" : "_" + stub_name + "Stub";
            ps.println("\t\t\t\t" + stub_name + " stub;");
            ps.println("\t\t\t\tstub = new " + stub_name + "();");
            ps.println("\t\t\t\tstub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
            ps.println("\t\t\t\treturn stub;");
            ps.println("\t\t}");
        } else {
            ps.println("\t\tif (obj instanceof " + this.typeName() + ")");
            ps.println("\t\t\treturn (" + this.typeName() + ")obj;");
            ps.println("\t\telse");
            ps.println("\t\tthrow new org.omg.CORBA.BAD_PARAM(\"unchecked_narrow failed, not a " + this.typeName() + "\");");
        }
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    public String[] get_ids() {
        if (this.ids == null) {
            HashSet<String> base_ids = new HashSet<String>();
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                Iterator i = this.inheritanceSpec.v.iterator();
                while (i.hasNext()) {
                    TypeSpec ts = ((ScopedName)i.next()).resolvedTypeSpec();
                    if (ts instanceof ConstrTypeSpec) {
                        Interface base = (Interface)((ConstrTypeSpec)ts).c_type_spec;
                        base_ids.addAll(Arrays.asList(base.get_ids()));
                        continue;
                    }
                    if (!(ts instanceof ReplyHandlerTypeSpec)) continue;
                    base_ids.add("IDL:omg.org/Messaging/ReplyHandler:1.0");
                }
            }
            this.ids = new String[base_ids.size() + 1];
            this.ids[0] = this.id();
            int i = 1;
            Iterator j = base_ids.iterator();
            while (j.hasNext()) {
                this.ids[i] = (String)j.next();
                ++i;
            }
        }
        return this.ids;
    }

    protected void printStub() {
        PrintWriter ps = this.openOutput("_" + this.name + "Stub");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printImport(ps);
        this.printClassComment(this.name, ps);
        ps.println("public class _" + this.name + "Stub");
        ps.println("\textends org.omg.CORBA.portable.ObjectImpl");
        ps.println("\timplements " + this.javaName());
        ps.println("{");
        ps.print("\tprivate String[] ids = {");
        String[] ids = this.get_ids();
        for (int i = 0; i < ids.length - 1; ++i) {
            ps.print("\"" + ids[i] + "\",");
        }
        ps.println("\"" + ids[ids.length - 1] + "\"};");
        ps.println("\tpublic String[] _ids()");
        ps.println("\t{");
        ps.println("\t\treturn ids;");
        ps.println("\t}\n");
        if (!parser.cldc10) {
            ps.print("\tpublic final static java.lang.Class _opsClass = ");
            if (!this.pack_name.equals("")) {
                ps.print(this.pack_name + ".");
            }
            if (this.is_abstract) {
                ps.println(this.name + ".class;");
            } else {
                ps.println(this.name + "Operations.class;");
            }
        } else {
            String fullName = null;
            fullName = !this.pack_name.equals("") ? this.pack_name + "." + this.name : this.name;
            ps.println("\tpublic static final java.lang.Class _opsClass;");
            ps.println("\tstatic");
            ps.println("\t{");
            ps.println("\t\ttry");
            ps.println("\t\t{");
            ps.print("\t\t\t_opsClass = Class.forName(\"");
            if (!this.pack_name.equals("")) {
                ps.print(this.pack_name + ".");
            }
            ps.println(this.name + "Operations\");");
            ps.println("\t\t}");
            ps.println("\t\tcatch(ClassNotFoundException cnfe)");
            ps.println("\t\t{");
            ps.println("\t\t\tthrow new RuntimeException(\"Class " + fullName + " was not found.\");");
            ps.println("\t\t}");
            ps.println("\t}\n");
        }
        this.body.printStubMethods(ps, this.name, this.is_local, this.is_abstract);
        ps.println("}");
        ps.close();
    }

    protected void printImplSkeleton() {
        PrintWriter ps = this.openOutput(this.name + "POA");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        this.printClassComment(this.name, ps);
        this.printImport(ps);
        ps.print("public abstract class " + this.name + "POA");
        ps.println("\n\textends org.omg.PortableServer.Servant");
        ps.println("\timplements org.omg.CORBA.portable.InvokeHandler, " + this.javaName() + "Operations");
        ps.println("{");
        this.body.printOperationsHash(ps);
        ps.print("\tprivate String[] ids = {");
        String[] ids = this.get_ids();
        for (int i = 0; i < ids.length - 1; ++i) {
            ps.print("\"" + ids[i] + "\",");
        }
        ps.println("\"" + ids[ids.length - 1] + "\"};");
        ps.println("\tpublic " + this.javaName() + " _this()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object());");
        ps.println("\t}");
        ps.println("\tpublic " + this.javaName() + " _this(org.omg.CORBA.ORB orb)");
        ps.println("\t{");
        ps.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object(orb));");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.portable.OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream _input, org.omg.CORBA.portable.ResponseHandler handler)");
        ps.println("\t\tthrows org.omg.CORBA.SystemException");
        ps.println("\t{");
        ps.println("\t\torg.omg.CORBA.portable.OutputStream _out = null;");
        ps.println("\t\t// do something");
        this.body.printSkelInvocations(ps);
        ps.println("\t}\n");
        ps.println("\tpublic String[] _all_interfaces(org.omg.PortableServer.POA poa, byte[] obj_id)");
        ps.println("\t{");
        ps.println("\t\treturn ids;");
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printTieSkeleton() {
        PrintWriter ps = this.openOutput(this.name + "POATie");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        ps.println("import org.omg.PortableServer.POA;");
        this.printImport(ps);
        this.printClassComment(this.name, ps);
        ps.println("public class " + this.name + "POATie");
        ps.println("\textends " + this.name + "POA");
        ps.println("{");
        ps.println("\tprivate " + this.name + "Operations _delegate;\n");
        ps.println("\tprivate POA _poa;");
        ps.println("\tpublic " + this.name + "POATie(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "POATie(" + this.name + "Operations delegate, POA poa)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t\t_poa = poa;");
        ps.println("\t}");
        ps.println("\tpublic " + this.javaName() + " _this()");
        ps.println("\t{");
        ps.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object());");
        ps.println("\t}");
        ps.println("\tpublic " + this.javaName() + " _this(org.omg.CORBA.ORB orb)");
        ps.println("\t{");
        ps.println("\t\treturn " + this.javaName() + "Helper.narrow(_this_object(orb));");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "Operations _delegate()");
        ps.println("\t{");
        ps.println("\t\treturn _delegate;");
        ps.println("\t}");
        ps.println("\tpublic void _delegate(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        ps.println("\tpublic POA _default_POA()");
        ps.println("\t{");
        ps.println("\t\tif (_poa != null)");
        ps.println("\t\t{");
        ps.println("\t\t\treturn _poa;");
        ps.println("\t\t}");
        ps.println("\t\telse");
        ps.println("\t\t{");
        ps.println("\t\t\treturn super._default_POA();");
        ps.println("\t\t}");
        ps.println("\t}");
        this.body.printDelegatedMethods(ps);
        ps.println("}");
        ps.close();
    }

    protected void printIRHelper() {
        PrintWriter ps = this.openOutput(this.name + "IRHelper");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        ps.println("\n/**");
        ps.println(" * This class contains generated Interface Repository information.");
        ps.println(" * @author JacORB IDL compiler.");
        ps.println(" */");
        ps.println("\npublic class " + this.name + "IRHelper");
        ps.println("{");
        String HASHTABLE = System.getProperty("java.version").startsWith("1.1") ? "com.sun.java.util.collections.Hashtable" : "java.util.Hashtable";
        ps.println("\tpublic static " + HASHTABLE + " irInfo = new " + HASHTABLE + "();");
        ps.println("\tstatic");
        ps.println("\t{");
        this.body.getIRInfo(this.irInfoTable);
        Enumeration e = this.irInfoTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ps.println("\t\tirInfo.put(\"" + key + "\", \"" + (String)this.irInfoTable.get(key) + "\");");
        }
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printLocalBase() {
        PrintWriter ps = this.openOutput("_" + this.name + "LocalBase");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        ps.println("\n/**");
        ps.println(" * Abstract base class for implementations of local interface " + this.name);
        ps.println(" * @author JacORB IDL compiler.");
        ps.println(" */");
        ps.println("\npublic abstract class _" + this.name + "LocalBase");
        ps.println("\textends org.omg.CORBA.LocalObject");
        ps.println("\timplements " + this.name);
        ps.println("{");
        ps.print("\tprivate String[] _type_ids = {");
        String[] ids = this.get_ids();
        for (int i = 0; i < ids.length - 1; ++i) {
            ps.print("\"" + ids[i] + "\",");
        }
        ps.println("\"" + ids[ids.length - 1] + "\"};");
        ps.print("\tpublic String[] _ids()");
        ps.println("\t{");
        ps.println("\t\treturn(String[])_type_ids.clone();");
        ps.println("\t}");
        ps.println("}");
        ps.close();
    }

    protected void printLocalTie() {
        PrintWriter ps = this.openOutput(this.name + "LocalTie");
        if (ps == null) {
            return;
        }
        this.printPackage(ps);
        ps.println("import org.omg.PortableServer.POA;");
        this.printImport(ps);
        this.printClassComment(this.name, ps);
        ps.println("public class " + this.name + "LocalTie");
        ps.println("\textends _" + this.name + "LocalBase");
        ps.println("{");
        ps.println("\tprivate " + this.name + "Operations _delegate;\n");
        ps.println("\tprivate POA _poa;");
        ps.println("\tpublic " + this.name + "LocalTie(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        ps.println("\tpublic " + this.name + "Operations _delegate()");
        ps.println("\t{");
        ps.println("\t\treturn _delegate;");
        ps.println("\t}");
        ps.println("\tpublic void _delegate(" + this.name + "Operations delegate)");
        ps.println("\t{");
        ps.println("\t\t_delegate = delegate;");
        ps.println("\t}");
        this.body.printDelegatedMethods(ps);
        ps.println("}");
        ps.close();
    }

    public void print(PrintWriter _ps) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.body != null) {
            this.printInterface();
            if (!this.is_pseudo) {
                if (!this.is_abstract) {
                    this.printOperations();
                }
                this.printHelper();
                this.printHolder();
                if (parser.generate_stubs && !this.is_local) {
                    this.printStub();
                }
                if (parser.generate_skeletons && !this.is_local && !this.is_abstract) {
                    this.printImplSkeleton();
                    this.printTieSkeleton();
                }
                if (parser.generateIR) {
                    this.printIRHelper();
                }
                if (this.is_local) {
                    this.printLocalBase();
                    this.printLocalTie();
                }
            }
            this.body.print(null);
            if (this.replyHandler != null) {
                this.replyHandler.print(_ps);
            }
        }
    }

    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        if (this.is_abstract) {
            throw new RuntimeException("DII stubs not yet implemented for abstract interfaces");
        }
        ps.println("\t\t" + anyname + ".insert_Object(" + varname + ");");
    }

    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + this.helperName() + ".extract(" + anyname + ");");
    }

    public void accept(IDLTreeVisitor visitor) {
        visitor.visitInterface(this);
    }
}

