/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class FixedPointType
extends TemplateTypeSpec {
    public ConstExpr digit_expr = null;
    public ConstExpr scale_expr = null;
    private int digits = 0;
    private int scale = 0;

    public FixedPointType(int num) {
        super(num);
    }

    public Object clone() {
        FixedPointType ft = new FixedPointType(FixedPointType.new_num());
        ft.name = this.name;
        ft.pack_name = this.pack_name;
        ft.digit_expr = this.digit_expr;
        ft.digits = this.digits;
        ft.scale_expr = this.scale_expr;
        ft.scale = this.scale;
        ft.included = this.included;
        ft.typedefd = this.typedefd;
        ft.set_token(this.get_token());
        ft.setEnclosingSymbol(this.getEnclosingSymbol());
        return ft;
    }

    public String helperName() {
        if (this.pack_name.length() > 0) {
            String s = ScopedName.unPseudoName(this.pack_name + "." + this.name);
            if (!s.startsWith("org.omg")) {
                return this.omg_package_prefix + s;
            }
            return s;
        }
        return ScopedName.unPseudoName(this.name);
    }

    public String typeName() {
        return "java.math.BigDecimal";
    }

    public String getIDLTypeName() {
        return "fixed";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    private void printHelperClass(String className, PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        ps.println("\tpublic static void insert(org.omg.CORBA.Any any, java.math.BigDecimal s)");
        ps.println("\t{");
        ps.println("\t\tany.insert_fixed(s, type());");
        ps.println("\t}");
        ps.println("\tpublic static java.math.BigDecimal extract(org.omg.CORBA.Any any)");
        ps.println("\t{");
        ps.println("\t\treturn any.extract_fixed();");
        ps.println("\t}");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type()");
        ps.println("\t{");
        ps.println("\t\treturn _type;");
        ps.println("\t}");
        this.printIdMethod(ps);
        ps.println("\tpublic static java.math.BigDecimal read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tjava.math.BigDecimal result = in.read_fixed();");
        ps.println("\t\treturn result.movePointLeft(" + this.scale + ");");
        ps.println("\t}");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final java.math.BigDecimal s)");
        ps.println("\t{");
        StringBuffer mb = new StringBuffer("1");
        for (int m = 0; m < this.digits - this.scale; ++m) {
            mb.append("0");
        }
        ps.println("\t\tif (s.scale() != " + this.scale + ")");
        ps.println("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION();");
        ps.println("\t\tjava.math.BigDecimal max = new java.math.BigDecimal(\"" + mb.toString() + "\");");
        ps.println("\t\tif (s.compareTo(max) != -1)");
        ps.println("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION();");
        ps.println("\t\tout.write_fixed(s);");
        ps.println("\t}");
        ps.println("}");
    }

    public void print(PrintWriter pw) {
        try {
            String fname;
            File f;
            String className;
            String fullName = this.helperName();
            if (fullName.indexOf(46) > 0) {
                this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
                className = fullName.substring(fullName.lastIndexOf(46) + 1);
            } else {
                this.pack_name = "";
                className = fullName;
            }
            String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
            File dir = new File(path);
            if (!dir.exists() && !dir.mkdirs()) {
                parser.fatal_error("Unable to create " + path, null);
            }
            if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                PrintWriter ps = new PrintWriter(new FileWriter(f));
                this.printHelperClass(className, ps);
                ps.close();
            }
        }
        catch (IOException i) {
            throw new RuntimeException("File IO error" + i);
        }
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.FixedHolder";
    }

    public String getTypeCodeExpression() {
        return "org.omg.CORBA.ORB.init().create_fixed_tc((short)" + this.digits + ",(short)" + this.scale + ")";
    }

    public String printReadExpression(String strname) {
        return this.helperName() + "Helper.read(" + strname + ")";
    }

    public String printReadStatement(String var_name, String strname) {
        String fixedName = null;
        fixedName = this.hashCode() > 0 ? "_fixed" + this.hashCode() : "_fixed" + -1 * this.hashCode();
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tjava.math.BigDecimal " + fixedName + "=" + strname + ".read_fixed();\n");
        sb.append("\t\t" + var_name + " = " + fixedName + ".movePointLeft(" + this.scale + ");\n");
        return sb.toString();
    }

    public String printWriteStatement(String var_name, String strname) {
        StringBuffer mb = new StringBuffer("1");
        for (int m = 0; m < this.digits - this.scale; ++m) {
            mb.append("0");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n\t\tif (" + var_name + ".scale() != " + this.scale + ")\n");
        sb.append("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION(\"wrong scale in fixed point value, expecting " + this.scale + ", got \" + " + var_name + ".scale());\n");
        String max = null;
        max = this.hashCode() > 0 ? "_max" + this.hashCode() : "_max" + -1 * this.hashCode();
        sb.append("\t\tjava.math.BigDecimal " + max + "= new java.math.BigDecimal(\"" + mb.toString() + "\");\n");
        sb.append("\t\tif (" + var_name + ".compareTo(" + max + ") != -1)\n");
        sb.append("\t\t\tthrow new org.omg.CORBA.DATA_CONVERSION(\"more than " + this.digits + " digits in fixed point value\");\n");
        sb.append("\t\t" + strname + ".write_fixed(" + var_name + ");\n");
        return sb.toString();
    }

    public void parse() {
        this.digits = this.digit_expr.pos_int_const();
        this.scale = this.scale_expr.pos_int_const();
        if (this.scale < 0 || this.digits <= 0 || this.scale > this.digits) {
            parser.error("Error in fixed point type " + this.typeName() + ", invalid format: <" + this.digits + "," + this.scale + ">");
        }
    }

    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        String fullName = this.helperName();
        String className = fullName.indexOf(46) > 0 ? fullName.substring(fullName.lastIndexOf(46) + 1) : fullName;
        String helpername = className + "Helper";
        ps.println("\t\t" + helpername + ".insert(" + anyname + ", " + varname + " )");
    }

    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        throw new RuntimeException("DII-stubs not completely implemented for fixed-point types");
    }
}

