/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.ClassicInstrumentor;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassifier;

public class InstrumentorFactory {
    protected static final int CLASSIC = 1;
    protected static final int GENERATED_ADVISOR = 2;
    protected static final int OTHER_INSTRUMENTOR = 1000;
    protected static int instrumentor = 0;
    protected static Constructor otherInstrumentorConstructor;
    private static final Class[] CONSTRUCTOR_SIG;

    public static void initialise(String property) {
        if (AspectManager.verbose) {
            System.out.println("[debug] Passed in instrumentor: " + property);
        }
        if (property != null) {
            if (property.equals(ClassicInstrumentor.class.getName())) {
                instrumentor = 1;
            } else if (property.equals(GeneratedAdvisorInstrumentor.class.getName())) {
                instrumentor = 2;
            } else {
                try {
                    Class<?> otherInstrumentorClass = Thread.currentThread().getContextClassLoader().loadClass(property);
                    otherInstrumentorConstructor = otherInstrumentorClass.getConstructor(CONSTRUCTOR_SIG);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Invalid instrumentor " + property + " was used");
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(property + " does not have a constructor with the expected signature");
                }
            }
        } else {
            if (AspectManager.verbose) {
                System.out.println("[debug] Defaulting instrumentor to: " + ClassicInstrumentor.class.getName());
            }
            instrumentor = 1;
        }
    }

    public static Instrumentor getInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer) {
        if (instrumentor == 1) {
            return new ClassicInstrumentor(pool, manager, joinpointClassifier, observer);
        }
        if (instrumentor == 2) {
            return new GeneratedAdvisorInstrumentor(pool, manager, joinpointClassifier, observer);
        }
        if (otherInstrumentorConstructor != null) {
            try {
                return (Instrumentor)otherInstrumentorConstructor.newInstance(new Object[]{pool, manager, joinpointClassifier, observer});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Instrumentor is not set");
    }

    public static Instrumentor getInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier) {
        switch (instrumentor) {
            case 1: {
                return new ClassicInstrumentor(manager, joinpointClassifier);
            }
            case 2: {
                return new GeneratedAdvisorInstrumentor(manager, joinpointClassifier);
            }
        }
        throw new RuntimeException("Instrumentor is not set");
    }

    static {
        CONSTRUCTOR_SIG = new Class[]{AOPClassPool.class, AspectManager.class, JoinpointClassifier.class, DynamicTransformationObserver.class};
    }
}

