/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.HibernateQuery;

public class QueryImpl
implements javax.persistence.Query,
HibernateQuery {
    private Query query;
    private HibernateEntityManagerImplementor em;

    public QueryImpl(Query query, AbstractEntityManagerImpl em) {
        this.query = query;
        this.em = em;
    }

    public Query getHibernateQuery() {
        return this.query;
    }

    public int executeUpdate() {
        try {
            if (!this.em.isTransactionInProgress()) {
                this.em.throwPersistenceException((PersistenceException)new TransactionRequiredException("Executing an update/delete query"));
                return 0;
            }
            return this.query.executeUpdate();
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return 0;
        }
    }

    public List getResultList() {
        try {
            return this.query.list();
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public Object getSingleResult() {
        try {
            Object result = this.query.uniqueResult();
            if (result == null) {
                this.em.throwPersistenceException((PersistenceException)new NoResultException("No entity found for query"));
            }
            return result;
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("Negative (" + maxResult + ") parameter passed in to setMaxResults");
        }
        this.query.setMaxResults(maxResult);
        return this;
    }

    public javax.persistence.Query setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setMaxResults");
        }
        this.query.setFirstResult(firstResult);
        return this;
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                this.query.setTimeout(((Integer)value).intValue());
            } else if ("org.hibernate.comment".equals(hintName)) {
                this.query.setComment((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                this.query.setFetchSize(((Integer)value).intValue());
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                this.query.setCacheRegion((String)value);
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                this.query.setCacheable(((Boolean)value).booleanValue());
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                this.query.setReadOnly(((Boolean)value).booleanValue());
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                this.query.setCacheMode((CacheMode)value);
            } else if ("org.hibernate.flushMode".equals(hintName)) {
                this.query.setFlushMode((FlushMode)value);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Object value) {
        try {
            if (value instanceof Collection) {
                this.query.setParameterList(name, (Collection)value);
            } else {
                this.query.setParameter(name, value);
            }
            return this;
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        try {
            if (temporalType == TemporalType.DATE) {
                this.query.setDate(name, value);
            } else if (temporalType == TemporalType.TIME) {
                this.query.setTime(name, value);
            } else if (temporalType == TemporalType.TIMESTAMP) {
                this.query.setTimestamp(name, value);
            }
            return this;
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        try {
            if (temporalType == TemporalType.DATE) {
                this.query.setCalendarDate(name, value);
            } else {
                if (temporalType == TemporalType.TIME) {
                    throw new IllegalArgumentException("not yet implemented");
                }
                if (temporalType == TemporalType.TIMESTAMP) {
                    this.query.setCalendar(name, value);
                }
            }
            return this;
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(int position, Object value) {
        try {
            if (this.isEJBQLQuery()) {
                this.setParameter(Integer.toString(position), value);
            } else {
                this.query.setParameter(position - 1, value);
            }
            return this;
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    private boolean isEJBQLQuery() {
        return !(this.query instanceof SQLQuery);
    }

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        try {
            if (this.isEJBQLQuery()) {
                String name = Integer.toString(position);
                this.setParameter(name, value, temporalType);
            } else if (temporalType == TemporalType.DATE) {
                this.query.setDate(position - 1, value);
            } else if (temporalType == TemporalType.TIME) {
                this.query.setTime(position - 1, value);
            } else if (temporalType == TemporalType.TIMESTAMP) {
                this.query.setTimestamp(position - 1, value);
            }
            return this;
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        try {
            if (this.isEJBQLQuery()) {
                String name = Integer.toString(position);
                this.setParameter(name, value, temporalType);
            } else if (temporalType == TemporalType.DATE) {
                this.query.setCalendarDate(position - 1, value);
            } else {
                if (temporalType == TemporalType.TIME) {
                    throw new IllegalArgumentException("not yet implemented");
                }
                if (temporalType == TemporalType.TIMESTAMP) {
                    this.query.setCalendar(position - 1, value);
                }
            }
            return this;
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.query.setFlushMode(FlushMode.AUTO);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.query.setFlushMode(FlushMode.COMMIT);
        }
        return this;
    }
}

