/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.util.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import org.jboss.ant.util.graph.Edge;
import org.jboss.ant.util.graph.Vertex;
import org.jboss.ant.util.graph.Visitor;

public class Graph {
    public static final int VISIT_COLOR_WHITE = 1;
    public static final int VISIT_COLOR_GREY = 2;
    public static final int VISIT_COLOR_BLACK = 3;
    private Vector verticies = new Vector();
    private Vector edges = new Vector();

    public boolean isEmpty() {
        return this.verticies.size() == 0;
    }

    public boolean addVertex(Vertex v) {
        return this.verticies.add(v);
    }

    public int size() {
        return this.verticies.size();
    }

    public Vertex getVertex(int n) {
        Vertex v = (Vertex)this.verticies.get(n);
        return v;
    }

    public boolean addEdge(Vertex from, Vertex to, int cost) {
        Edge ed = new Edge(from, to, cost);
        if (from.findEdge(to) != null) {
            return false;
        }
        from.addEdge(ed);
        to.addEdge(ed);
        this.edges.addElement(ed);
        return true;
    }

    public boolean insertBiEdge(Vertex from, Vertex to, int cost) {
        return this.addEdge(from, to, cost) && this.addEdge(to, from, cost);
    }

    public boolean removeVertex(Vertex from) {
        Edge e;
        int n;
        if (!this.verticies.contains(from)) {
            return false;
        }
        this.verticies.removeElement(from);
        for (n = 0; n < from.getOutgoingEdgeCount(); ++n) {
            e = from.getOutgoingEdge(n);
            from.remove(e);
            Vertex to = e.getTo();
            to.remove(e);
            this.edges.removeElement(e);
        }
        for (n = 0; n < from.getIncomingEdgeCount(); ++n) {
            e = from.getIncomingEdge(n);
            from.remove(e);
            Vertex predecessor = e.getFrom();
            predecessor.remove(e);
        }
        return true;
    }

    public boolean removeEdge(Vertex from, Vertex to) {
        Edge e = from.findEdge(to);
        if (e == null) {
            return false;
        }
        from.remove(e);
        to.remove(e);
        this.edges.removeElement(e);
        return true;
    }

    public void clearMark() {
        for (int i = 0; i < this.verticies.size(); ++i) {
            Vertex w = (Vertex)this.verticies.elementAt(i);
            w.clearMark();
        }
    }

    public void clearEdges() {
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge e = (Edge)this.edges.elementAt(i);
            e.clearMark();
        }
    }

    public void depthFirstSearch(Vertex v, Visitor visitor) {
        if (visitor != null) {
            visitor.visit(this, v);
        }
        v.visit();
        for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
            Edge e = v.getOutgoingEdge(i);
            if (e.getTo().visited()) continue;
            this.depthFirstSearch(e.getTo(), visitor);
        }
    }

    public void breadthFirstSearch(Vertex v, Visitor visitor) {
        LinkedList<Vertex> q = new LinkedList<Vertex>();
        q.add(v);
        if (visitor != null) {
            visitor.visit(this, v);
        }
        v.visit();
        while (!q.isEmpty()) {
            v = (Vertex)q.removeFirst();
            for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
                Edge e = v.getOutgoingEdge(i);
                if (e.getTo().visited()) continue;
                q.add(e.getTo());
                if (visitor != null) {
                    visitor.visit(this, e.getTo());
                }
                e.getTo().visit();
            }
        }
    }

    public void dfsSpanningTree(Vertex v, Visitor visitor) {
        v.visit();
        if (visitor != null) {
            visitor.visit(this, v);
        }
        for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
            Edge e = v.getOutgoingEdge(i);
            if (e.getTo().visited()) continue;
            if (visitor != null) {
                visitor.visit(this, v, e);
            }
            e.mark();
            this.dfsSpanningTree(e.getTo(), visitor);
        }
    }

    public Edge[] findCycles() {
        Vertex v;
        int n;
        ArrayList cycleEdges = new ArrayList();
        for (n = 0; n < this.verticies.size(); ++n) {
            v = this.getVertex(n);
            v.setMarkState(1);
        }
        for (n = 0; n < this.verticies.size(); ++n) {
            v = this.getVertex(n);
            this.visit(v, cycleEdges);
        }
        Edge[] cycles = new Edge[cycleEdges.size()];
        cycleEdges.toArray(cycles);
        return cycles;
    }

    private void visit(Vertex v, ArrayList cycleEdges) {
        v.setMarkState(2);
        int count = v.getOutgoingEdgeCount();
        for (int n = 0; n < count; ++n) {
            Edge e = v.getOutgoingEdge(n);
            Vertex u = e.getTo();
            if (u.getMarkState() == 2) {
                cycleEdges.add(e);
                continue;
            }
            if (u.getMarkState() != 1) continue;
            this.visit(u, cycleEdges);
        }
        v.setMarkState(3);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("Graph[");
        for (int i = 0; i < this.verticies.size(); ++i) {
            Vertex v = (Vertex)this.verticies.elementAt(i);
            tmp.append(v);
        }
        tmp.append(']');
        return tmp.toString();
    }
}

