/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.build;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jboss.ant.targets.ComponentMainTarget;
import org.jboss.ant.targets.ComponentTarget;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.Export;
import org.jboss.ant.types.Import;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.attributes.Version;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.build.Build;
import org.jboss.ant.types.component.ComponentDefinition;
import org.jboss.ant.types.target.TargetDefinition;
import org.jboss.ant.types.target.TargetDefinitions;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.ReferenceUtil;

public class Component
extends Source {
    private Build build;
    private Vector artifacts = new Vector();
    private Vector imports = new Vector();
    private String outputPath = "output";
    private String sourcePath = "src";
    private String classesPath = "classes";
    private String resourcePath = "resources";
    private String resourceOutputPath = "resources";
    private String generatedSourceOutputPath = "gen-src";
    private String libPath = "lib";
    private String apiPath = "api";
    private String binPath = "bin";
    private String dtdPath = "resources/dtd";
    private String schemaPath = "resources/schema";
    private String testPath = "reports";
    private ComponentDefinition componentDefinition;
    private Export export;
    private String module;
    private String location;
    private String specVendor;
    private String specTitle;
    private String specVersion;
    private String implVendor = "UNSPECIFIED";
    private String implTitle = "UNSPECIFED";
    private String implVersion = "UNSPECIFED";
    private String implURL = "UNSPECIFED";
    private Version version;
    private String relativePath;
    private boolean executable;

    public Build getBuild() {
        if (this.build == null) {
            this.build = Build.getBuild();
        }
        return this.build;
    }

    public Vector getArtifacts() {
        return this.artifacts;
    }

    public Artifact createArtifact() {
        Artifact artifact = new Artifact();
        this.artifacts.add(artifact);
        artifact.setComponent(this);
        return artifact;
    }

    public void addExport(Export export) {
        if (this.export != null) {
            throw new IllegalStateException("Export already set for " + (Object)((Object)this));
        }
        this.export = export;
    }

    public void addImport(Import importTag) {
        importTag.setComponent(this);
        this.imports.add(importTag);
    }

    public Vector getImports() {
        return this.imports;
    }

    public Export getExport() {
        return this.export;
    }

    public File getDir() {
        return FileUtil.resolve(FileUtil.getRoot(this.getProject()), this.getName());
    }

    public boolean getExists() {
        boolean exists = false;
        if (!this.getDir().isDirectory()) {
            return exists;
        }
        if (this.getDir().list().length <= 2) {
            return exists;
        }
        return true;
    }

    public boolean isLocal() {
        return this.getExists() || this.module != null && this.isCheckout();
    }

    public boolean isStandalone() {
        return this.getBuild().isStandalone();
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
        if (this.log.isTraceEnabled()) {
            this.log.trace("setOutputPath, " + outputPath);
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getClassesPath() {
        return this.classesPath;
    }

    public void setClassesPath(String classesPath) {
        this.classesPath = classesPath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourceOutputPath() {
        return this.resourceOutputPath;
    }

    public void setResourceOutputPath(String resourceOutputPath) {
        this.resourceOutputPath = resourceOutputPath;
    }

    public void setGeneratedSourceOutputPath(String generatedSourceOutputPath) {
        this.generatedSourceOutputPath = generatedSourceOutputPath;
    }

    public String getGeneratedSourceOutputPath() {
        return this.generatedSourceOutputPath;
    }

    public String getLibPath() {
        return this.libPath;
    }

    public void setLibPath(String libPath) {
        this.libPath = libPath;
    }

    public String getAPIPath() {
        return this.apiPath;
    }

    public void setAPIPAth(String apiPath) {
        this.apiPath = apiPath;
    }

    public String getBinPath() {
        return this.binPath;
    }

    public void setBinPath(String binPath) {
        this.binPath = binPath;
    }

    public String getDTDPath() {
        return this.dtdPath;
    }

    public void setDTDPath(String dtdPath) {
        this.dtdPath = dtdPath;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    public void setComponentDefinition(ComponentDefinition componentDefinition) {
        if (this.componentDefinition != null) {
            throw new IllegalStateException("Component definition already set " + (Object)((Object)this));
        }
        this.componentDefinition = componentDefinition;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public URL getLocation() throws MalformedURLException {
        URL locationURL = null;
        locationURL = this.location != null ? new URL(this.location) : this.build.getLocation();
        URL componentLocation = FileUtil.resolve(locationURL, this.getId());
        if (this.version != null) {
            return FileUtil.resolve(componentLocation, this.version.toString());
        }
        return componentLocation;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setVersion(String version) {
        this.version = new Version(version);
    }

    public Version getVersion() {
        return this.version;
    }

    public String getSpecTitle() {
        if (this.specTitle == null) {
            return this.implTitle;
        }
        return this.specTitle;
    }

    public void setSpecTitle(String title) {
        this.specTitle = title;
    }

    public String getSpecVersion() {
        if (this.specVersion == null) {
            return this.implVersion;
        }
        return this.specVersion;
    }

    public void setSpecVersion(String version) {
        this.specVersion = version;
    }

    public String getSpecVendor() {
        if (this.specVendor == null) {
            return this.implVendor;
        }
        return this.specVendor;
    }

    public void setSpecVendor(String vendor) {
        this.specVendor = vendor;
    }

    public String getImplTitle() {
        return this.implTitle;
    }

    public void setImplTitle(String title) {
        this.implTitle = title;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public void setImplVersion(String version) {
        this.implVersion = version;
    }

    public String getImplVendor() {
        return this.implVendor;
    }

    public void setImplVendor(String vendor) {
        this.implVendor = vendor;
    }

    public String getImplURL() {
        return this.implURL;
    }

    public void setImplURL(String url) {
        this.implURL = url;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        if (this.relativePath != null) {
            return this.relativePath;
        }
        if (this.version != null) {
            return this.getId() + "/" + this.version;
        }
        return this.getId();
    }

    public String getThirdpartyPath() {
        return this.getProject().getProperty("jbossbuild.thirdparty.dir");
    }

    public File getThirdparty() {
        return FileUtil.resolve(FileUtil.getRoot(this.getProject()), this.getThirdpartyPath());
    }

    public Vector getTargetDefinitions() {
        return this.resolveTargetDefinitions().getTargetDefinitions();
    }

    public File getThirdpartyDir() {
        File thirdpartyRoot = FileUtil.resolve(this.getThirdparty(), this.getId());
        return thirdpartyRoot;
    }

    public File getOutput() {
        File result = super.getOutput();
        if (result == null) {
            result = !this.isLocal() ? this.getThirdpartyDir() : FileUtil.resolve(this.getDir(), this.getOutputPath());
        }
        return result;
    }

    public void generate() {
        if (this.componentDefinition == null) {
            throw new IllegalStateException("Component definition not set " + (Object)((Object)this));
        }
        this.componentDefinition.generate();
    }

    public String getVMVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    protected void doValidate() {
        this.validate(this.artifacts);
        this.validate(this.imports);
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        buffer.append(" version=").append(this.version);
        buffer.append(" isLocal=").append(this.isLocal());
        buffer.append(" artifacts=").append(this.artifacts);
        if (this.componentDefinition != null) {
            buffer.append(" CD=").append(this.componentDefinition.toShortString());
        }
        buffer.append(" module=").append(this.module);
        buffer.append(" location=").append(this.location);
    }

    protected void generateTargets() {
        if (this.build.isBuild()) {
            if (this.isLocal()) {
                this.generateComponentTargets();
            }
            this.generateComponentMainTargets();
        }
        this.generateArtifactTargets();
    }

    protected void generateComponentTargets() {
        Vector definitions = this.getBuild().getTargetDefinitions();
        block0: for (int i = 0; i < definitions.size(); ++i) {
            TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
            List dynamicTypes = definition.getComponent();
            if (dynamicTypes == null) continue;
            for (int j = 0; j < dynamicTypes.size(); ++j) {
                DynamicType type = (DynamicType)((Object)dynamicTypes.get(j));
                if (type.getAttribute("nomain", null) != null) continue;
                this.build.addDependency(new ComponentTarget(this, definition));
                continue block0;
            }
        }
    }

    protected void generateComponentMainTargets() {
        Vector definitions = this.getBuild().getTargetDefinitions();
        block0: for (int i = 0; i < definitions.size(); ++i) {
            TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
            ArrayList dynamicTypes = definition.getElement("componentmain");
            if (dynamicTypes == null) continue;
            for (int j = 0; j < dynamicTypes.size(); ++j) {
                DynamicType type = (DynamicType)((Object)dynamicTypes.get(j));
                if (!type.applies((Object)this)) continue;
                this.build.addDependency(new ComponentMainTarget(this, definition));
                continue block0;
            }
        }
    }

    protected void generateArtifactTargets() {
        Vector artifacts = this.getArtifacts();
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact artifact = (Artifact)((Object)artifacts.get(i));
            artifact.generateTargets();
        }
    }

    protected TargetDefinitions resolveTargetDefinitions() {
        return ReferenceUtil.resolveTargetDefinitions(this.getProject());
    }

    protected void setBuild(Build build) {
        this.build = build;
    }

    protected File getLibraryDir() {
        return FileUtil.resolve(this.getOutput(), this.getLibPath());
    }

    protected File getAPIDir() {
        return FileUtil.resolve(this.getOutput(), this.getAPIPath());
    }

    protected File getResourceDir() {
        return FileUtil.resolve(this.getOutput(), this.getResourceOutputPath());
    }

    protected File getBinDir() {
        return FileUtil.resolve(this.getOutput(), this.getBinPath());
    }

    protected File getDTDDir() {
        return FileUtil.resolve(this.getOutput(), this.getDTDPath());
    }

    protected File getSchemaDir() {
        return FileUtil.resolve(this.getOutput(), this.getSchemaPath());
    }

    private boolean isCheckout() {
        String checkout = this.getProject().getProperty("checkout." + this.getId());
        return "true".equalsIgnoreCase(checkout) || "yes".equalsIgnoreCase(checkout);
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }
}

