/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.SortedSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jboss.ant.types.AbstractBuildDataType;
import org.jboss.ant.types.Compatible;
import org.jboss.ant.types.Import;
import org.jboss.ant.types.attributes.Version;
import org.jboss.ant.types.build.Build;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.util.FileUtil;

public class ComponentRef
extends AbstractBuildDataType {
    Project project;
    private String id;
    private String name;
    private String filename = "component-info.xml";
    private String location;
    private Version version;
    private String module;
    private SortedSet compatibles;
    private Build build;
    private Component component;
    private Component importingComponent;
    private boolean fileResolved;
    private File componentInfo;
    private boolean executable = true;

    public ComponentRef() {
        this.component = null;
        this.fileResolved = false;
    }

    public ComponentRef(Import theImport) {
        this.importingComponent = theImport.getComponent();
        this.id = theImport.getComponentRef();
        this.fileResolved = false;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public File getThirdparty() {
        return FileUtil.resolve(FileUtil.getRoot(this.getProject()), this.getThirdpartyPath());
    }

    public String getThirdpartyPath() {
        return this.getProject().getProperty("jbossbuild.thirdparty.dir");
    }

    public File getThirdpartyDir() {
        File thirdpartyRoot = FileUtil.resolve(this.getThirdparty(), this.getName());
        return thirdpartyRoot;
    }

    public File getComponentFile() {
        if (this.isLocal()) {
            return FileUtil.resolve(this.getDir(), this.getComponentFilename());
        }
        return FileUtil.resolve(this.getThirdpartyDir(), this.getComponentFilename());
    }

    private String getComponentFilename() {
        return this.filename;
    }

    private File getComponentInfo() {
        return FileUtil.resolve(this.getDir(), this.filename);
    }

    protected void doValidate() {
        if (this.name == null) {
            throw new BuildException("ComponentRef must have a name defined");
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public URL getLocation() throws MalformedURLException {
        URL locationURL = null;
        locationURL = this.location != null ? new URL(this.location) : this.build.getLocation();
        URL componentLocation = FileUtil.resolve(locationURL, this.getName());
        if (this.version != null) {
            return FileUtil.resolve(componentLocation, this.version.toString());
        }
        return componentLocation;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating a new version from string: '" + version + "' for componentRef with name: " + this.getName());
        }
        this.version = new Version(version);
    }

    public SortedSet getCompatibleVersions() {
        return this.compatibles;
    }

    public void setCompatibleVersions(SortedSet compatibles) {
        this.compatibles = compatibles;
        Compatible latest = (Compatible)compatibles.last();
        this.setVersion(latest.getVersion().toString());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Build getBuild() {
        if (this.build == null) {
            this.build = Build.getBuild();
        }
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getImportingComponent() {
        return this.importingComponent;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFileResolved() {
        return this.fileResolved;
    }

    public void setFileResolved(boolean fileResolved) {
        this.fileResolved = fileResolved;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ComponentRef");
        sb.append("{id=").append(this.id);
        sb.append(",name=").append(this.name);
        sb.append(",filename=").append(this.filename);
        sb.append(",location=").append(this.location);
        sb.append(",version=").append(this.version);
        sb.append(",compatibles=").append(this.compatibles);
        sb.append(",component=").append((Object)this.component);
        sb.append(",importingComponent=").append((Object)this.importingComponent);
        sb.append(",fileResolved=").append(this.fileResolved);
        sb.append('}');
        return sb.toString();
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public File getDir() {
        return FileUtil.resolve(FileUtil.getRoot(this.getProject()), this.getName());
    }

    public boolean isLocal() {
        return this.getExists() || this.module != null && this.isCheckout();
    }

    public boolean getExists() {
        return this.getDir().isDirectory();
    }

    private boolean isCheckout() {
        String checkout = this.getProject().getProperty("checkout." + this.getName());
        return "true".equalsIgnoreCase(checkout) || "yes".equalsIgnoreCase(checkout);
    }

    public boolean getExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }
}

