/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.component;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.jboss.ant.tasks.AbstractIDETask;
import org.jboss.ant.types.Include;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.build.Artifact;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.types.component.ComponentDefinition;
import org.jboss.ant.types.component.SourceDefinition;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class IDETask
extends AbstractIDETask {
    public void execute() {
        super.execute();
        this.generateEclipseClasspath();
    }

    protected String getProjectName() {
        return this.getComponentDefinition().getComponent().getId();
    }

    protected String getProjectDescription() {
        return this.getComponentDefinition().getDescription();
    }

    protected boolean isUpToDate(String fileName) {
        File file = FileUtil.resolve(this.getBaseDir(), fileName);
        if (!file.exists()) {
            return false;
        }
        long lastModifiedFile = file.lastModified();
        File build = this.getBuildFile();
        if (build.lastModified() > lastModifiedFile) {
            return false;
        }
        File mainBuild = this.getMainBuildFile();
        return mainBuild == null || mainBuild.lastModified() <= lastModifiedFile;
    }

    protected File getBaseDir() {
        return this.getComponentDefinition().getProject().getBaseDir();
    }

    protected void appendEclipseBuildSpec(Element buildSpec) {
        if (this.getComponentDefinition().getSources().size() == 0) {
            return;
        }
        Document document = buildSpec.getOwnerDocument();
        Element buildCommand = document.createElement("buildCommand");
        buildSpec.appendChild(buildCommand);
        Element name = document.createElement("name");
        buildCommand.appendChild(name);
        Text nameText = document.createTextNode("org.eclipse.jdt.core.javabuilder");
        name.appendChild(nameText);
        Element arguments = document.createElement("arguments");
        buildCommand.appendChild(arguments);
    }

    protected void appendEclipseNatures(Element natures) {
        if (this.getComponentDefinition().getSources().size() == 0) {
            return;
        }
        Document document = natures.getOwnerDocument();
        Element nature = document.createElement("nature");
        natures.appendChild(nature);
        Text natureText = document.createTextNode("org.eclipse.jdt.core.javanature");
        nature.appendChild(natureText);
    }

    protected ComponentDefinition getComponentDefinition() {
        ComponentDefinition componentDefinition = ComponentDefinition.getComponentDefinition();
        if (componentDefinition == null) {
            throw new BuildException("No component definition?");
        }
        return componentDefinition;
    }

    protected File getBuildFile() {
        return this.getComponentDefinition().getComponent().getBuild().getBuildFile();
    }

    protected File getMainBuildFile() {
        return this.getComponentDefinition().getComponent().getBuild().getMainBuildFile();
    }

    protected void generateEclipseClasspath() {
        Element src;
        ComponentDefinition componentDefinition = this.getComponentDefinition();
        Vector sourceDefs = componentDefinition.getSources();
        if (sourceDefs.size() == 0) {
            return;
        }
        if (this.isUpToDate(".classpath")) {
            return;
        }
        String root = FileUtil.getRoot(componentDefinition.getProject()).toString();
        HashMap<String, String> sources = new HashMap<String, String>();
        HashSet<String> projects = new HashSet<String>();
        HashSet<String> libraries = new HashSet<String>();
        for (int i = 0; i < sourceDefs.size(); ++i) {
            SourceDefinition source = (SourceDefinition)((Object)sourceDefs.get(i));
            sources.put(source.getSourcePath(), "output/eclipse-classes/" + source.getId());
            for (int j = 0; j < source.getSize(); ++j) {
                Include include = source.getInclude(j);
                List inputs = include.getSources();
                for (int k = 0; k < inputs.size(); ++k) {
                    Source input = (Source)((Object)inputs.get(k));
                    if (input instanceof SourceDefinition) {
                        SourceDefinition sourceDefinition = (SourceDefinition)input;
                        ComponentDefinition componentDef = sourceDefinition.getComponentDefinition();
                        String projectName = componentDef.getComponent().getId();
                        projects.add(projectName);
                        continue;
                    }
                    Artifact artifact = (Artifact)input;
                    Component component = artifact.getComponent();
                    if (component.isLocal()) {
                        projects.add(component.getId());
                        continue;
                    }
                    String libName = artifact.getOutput().toString();
                    if (libName.startsWith(root)) {
                        libName = libName.substring(root.length());
                    }
                    libraries.add(libName);
                }
            }
        }
        Document document = XMLUtil.createDocument();
        Element classpath = document.createElement("classpath");
        document.appendChild(classpath);
        Iterator i = sources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            src = document.createElement("classpathentry");
            classpath.appendChild(src);
            src.setAttribute("kind", "src");
            src.setAttribute("path", entry.getKey().toString());
            src.setAttribute("output", entry.getValue().toString());
        }
        projects.remove(componentDefinition.getComponent().getId());
        i = projects.iterator();
        while (i.hasNext()) {
            String projectName = (String)((Object)i.next());
            src = document.createElement("classpathentry");
            classpath.appendChild(src);
            src.setAttribute("kind", "src");
            src.setAttribute("path", "/" + projectName);
        }
        i = libraries.iterator();
        while (i.hasNext()) {
            String libraryName = (String)((Object)i.next());
            Element lib = document.createElement("classpathentry");
            classpath.appendChild(lib);
            lib.setAttribute("kind", "lib");
            lib.setAttribute("path", libraryName);
        }
        Element jre = document.createElement("classpathentry");
        classpath.appendChild(jre);
        jre.setAttribute("kind", "con");
        jre.setAttribute("path", "org.eclipse.jdt.launching.JRE_CONTAINER");
        Element out = document.createElement("classpathentry");
        classpath.appendChild(out);
        out.setAttribute("kind", "output");
        out.setAttribute("path", "output/eclipse-classes");
        File file = FileUtil.resolve(this.getBaseDir(), ".classpath");
        XMLUtil.writeXMLDocument(file, document);
        this.log("Updated " + file);
    }
}

