/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.juddi.IRegistry;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.AssertionStatusItem;
import org.apache.juddi.datatype.response.AssertionStatusReport;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BindingDetail;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.BusinessList;
import org.apache.juddi.datatype.response.PublisherAssertions;
import org.apache.juddi.datatype.response.ServiceDetail;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.datatype.response.ServiceInfos;
import org.apache.juddi.datatype.response.ServiceList;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.datatype.response.TModelList;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.RegistryException;
import org.apache.log4j.Logger;
import org.apache.ws.scout.registry.BulkResponseImpl;
import org.apache.ws.scout.registry.BusinessLifeCycleManagerImpl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.RegistryServiceImpl;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.util.EnumerationHelper;
import org.apache.ws.scout.util.ScoutUddiJaxrHelper;

public class BusinessQueryManagerImpl
implements BusinessQueryManager {
    private final RegistryServiceImpl registryService;
    private static Logger log = Logger.getLogger((Class)(class$org$apache$ws$scout$registry$BusinessQueryManagerImpl == null ? (class$org$apache$ws$scout$registry$BusinessQueryManagerImpl = BusinessQueryManagerImpl.class$("org.apache.ws.scout.registry.BusinessQueryManagerImpl")) : class$org$apache$ws$scout$registry$BusinessQueryManagerImpl));
    private static final Map findQualifierMapping = new HashMap();
    static /* synthetic */ Class class$org$apache$ws$scout$registry$BusinessQueryManagerImpl;

    public BusinessQueryManagerImpl(RegistryServiceImpl registry) {
        this.registryService = registry;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public BulkResponse findOrganizations(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        try {
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
            Vector nameVector = BusinessQueryManagerImpl.mapNamePatterns(namePatterns);
            BusinessList result = registry.findBusiness(nameVector, null, null, null, null, juddiFindQualifiers, this.registryService.getMaxRows());
            Vector v = result.getBusinessInfos().getBusinessInfoVector();
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            int len = 0;
            if (v != null) {
                len = v.size();
                orgs = new ArrayList(len);
            }
            for (int i = 0; i < len; ++i) {
                BusinessInfo info = (BusinessInfo)v.elementAt(i);
                BusinessDetail detail = registry.getBusinessDetail(info.getBusinessKey());
                orgs.add(this.registryService.getLifeCycleManagerImpl().createOrganization(detail));
            }
            return new BulkResponseImpl(orgs);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse findAssociations(Collection findQualifiers, String sourceObjectId, String targetObjectId, Collection associationTypes) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            PublisherAssertions result = registry.getPublisherAssertions(auth.getAuthInfo());
            Vector v = result.getPublisherAssertionVector();
            ArrayList<Association> col = null;
            int len = 0;
            if (v != null) {
                len = v.size();
                col = new ArrayList<Association>(len);
            }
            for (int i = 0; i < len; ++i) {
                PublisherAssertion pas = (PublisherAssertion)v.elementAt(i);
                String sourceKey = pas.getFromKey();
                String targetKey = pas.getToKey();
                ArrayList<KeyImpl> orgcol = new ArrayList<KeyImpl>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiJaxrHelper.getAssociation(bl.getCollection(), (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                KeyedReference keyr = pas.getKeyedReference();
                ConceptImpl c = new ConceptImpl((LifeCycleManager)this.getRegistryService().getBusinessLifeCycleManager());
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setValue(keyr.getKeyValue());
                asso.setAssociationType((Concept)c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse findCallerAssociations(Collection findQualifiers, Boolean confirmedByCaller, Boolean confirmedByOtherParty, Collection associationTypes) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            AssertionStatusReport report = null;
            String confirm = "";
            boolean caller = confirmedByCaller;
            boolean other = confirmedByOtherParty;
            if (caller && other) {
                confirm = "status:complete";
            } else if (!caller && other) {
                confirm = "status:fromKey_incomplete";
            } else if (caller && !other) {
                confirm = "status:toKey_incomplete";
            }
            report = registry.getAssertionStatusReport(auth.getAuthInfo(), confirm);
            Vector v = report.getAssertionStatusItemVector();
            ArrayList<Association> col = new ArrayList<Association>();
            int len = 0;
            if (v != null) {
                len = v.size();
                col = new ArrayList(len);
            }
            for (int i = 0; i < len; ++i) {
                AssertionStatusItem asi = (AssertionStatusItem)v.elementAt(i);
                String sourceKey = asi.getFromKey();
                String targetKey = asi.getToKey();
                ArrayList<KeyImpl> orgcol = new ArrayList<KeyImpl>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiJaxrHelper.getAssociation(bl.getCollection(), (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                ((AssociationImpl)asso).setConfirmedBySourceOwner(caller);
                ((AssociationImpl)asso).setConfirmedByTargetOwner(other);
                if (confirm != "status:complete") {
                    ((AssociationImpl)asso).setConfirmed(false);
                }
                ConceptImpl c = new ConceptImpl((LifeCycleManager)this.getRegistryService().getBusinessLifeCycleManager());
                KeyedReference keyr = asi.getKeyedReference();
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setValue(keyr.getKeyValue());
                asso.setKey((Key)new KeyImpl(keyr.getTModelKey()));
                asso.setAssociationType((Concept)c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public ClassificationScheme findClassificationSchemeByName(Collection findQualifiers, String namePatterns) throws JAXRException {
        ClassificationSchemeImpl scheme = null;
        if (namePatterns.indexOf("uddi-org:types") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4"));
        } else if (namePatterns.indexOf("dnb-com:D-U-N-S") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("unspsc-org:unspsc") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
        } else if (namePatterns.indexOf("ntis-gov:naics") != -1) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2"));
        } else if ("AssociationType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "RelatedTo");
            this.addChildConcept(scheme, "HasChild");
            this.addChildConcept(scheme, "HasMember");
            this.addChildConcept(scheme, "HasParent");
            this.addChildConcept(scheme, "ExternallyLinks");
            this.addChildConcept(scheme, "Contains");
            this.addChildConcept(scheme, "EquivalentTo");
            this.addChildConcept(scheme, "Extends");
            this.addChildConcept(scheme, "Implements");
            this.addChildConcept(scheme, "InstanceOf");
            this.addChildConcept(scheme, "Supersedes");
            this.addChildConcept(scheme, "Uses");
            this.addChildConcept(scheme, "Replaces");
            this.addChildConcept(scheme, "ResponsibleFor");
            this.addChildConcept(scheme, "SubmitterOf");
        } else if ("ObjectType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "CPP");
            this.addChildConcept(scheme, "CPA");
            this.addChildConcept(scheme, "Process");
            this.addChildConcept(scheme, "WSDL");
            this.addChildConcept(scheme, "Association");
            this.addChildConcept(scheme, "AuditableEvent");
            this.addChildConcept(scheme, "Classification");
            this.addChildConcept(scheme, "Concept");
            this.addChildConcept(scheme, "ExternalIdentifier");
            this.addChildConcept(scheme, "ExternalLink");
            this.addChildConcept(scheme, "ExtrinsicObject");
            this.addChildConcept(scheme, "Organization");
            this.addChildConcept(scheme, "Package");
            this.addChildConcept(scheme, "Service");
            this.addChildConcept(scheme, "ServiceBinding");
            this.addChildConcept(scheme, "User");
        } else if ("PhoneType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "OfficePhone");
            this.addChildConcept(scheme, "HomePhone");
            this.addChildConcept(scheme, "MobilePhone");
            this.addChildConcept(scheme, "Beeper");
            this.addChildConcept(scheme, "FAX");
        } else if ("URLType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "HTTP");
            this.addChildConcept(scheme, "HTTPS");
            this.addChildConcept(scheme, "SMTP");
            this.addChildConcept(scheme, "PHONE");
            this.addChildConcept(scheme, "FAX");
            this.addChildConcept(scheme, "OTHER");
        } else if ("PostalAddressAttributes".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl(this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "StreetNumber");
            this.addChildConcept(scheme, "Street");
            this.addChildConcept(scheme, "City");
            this.addChildConcept(scheme, "State");
            this.addChildConcept(scheme, "PostalCode");
            this.addChildConcept(scheme, "Country");
        } else {
            IRegistry registry = this.registryService.getRegistry();
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
            Vector<String> nameVector = new Vector<String>();
            nameVector.add(namePatterns);
            try {
                TModelList list = registry.findTModel(namePatterns, null, null, juddiFindQualifiers, 3);
                TModelInfos infos = null;
                Vector tmvect = null;
                if (list != null) {
                    infos = list.getTModelInfos();
                }
                if (infos != null) {
                    tmvect = infos.getTModelInfoVector();
                }
                if (tmvect != null) {
                    if (tmvect.size() > 1) {
                        throw new InvalidRequestException("Multiple matches found");
                    }
                    TModelInfo info = (TModelInfo)tmvect.elementAt(0);
                    scheme.setName(new InternationalStringImpl(info.getName().getValue()));
                    scheme.setKey(new KeyImpl(info.getTModelKey()));
                }
            }
            catch (RegistryException e) {
                log.error((Object)"Exception ::", (Throwable)e);
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return scheme;
    }

    private void addChildConcept(ClassificationSchemeImpl scheme, String name) throws JAXRException {
        ConceptImpl c = new ConceptImpl(this.registryService.getLifeCycleManagerImpl());
        c.setName(new InternationalStringImpl(name));
        c.setValue(name);
        c.setScheme(scheme);
        scheme.addChildConcept(c);
    }

    public BulkResponse findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        ArrayList<ClassificationScheme> col = new ArrayList<ClassificationScheme>();
        Iterator iter = namePatterns.iterator();
        String name = "";
        if (iter.hasNext()) {
            name = (String)iter.next();
        }
        col.add(this.findClassificationSchemeByName(findQualifiers, name));
        return new BulkResponseImpl(col);
    }

    public Concept findConceptByPath(String path) throws JAXRException {
        return EnumerationHelper.getConceptByPath(path);
    }

    public BulkResponse findConcepts(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        ArrayList<Concept> col = new ArrayList<Concept>();
        IRegistry registry = this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        Iterator iter = null;
        if (namePatterns != null) {
            iter = namePatterns.iterator();
        }
        while (iter.hasNext()) {
            String namestr = (String)iter.next();
            try {
                TModelList list = registry.findTModel(namestr, null, null, juddiFindQualifiers, 10);
                TModelInfos infos = null;
                Vector tmvect = null;
                if (list != null) {
                    infos = list.getTModelInfos();
                }
                if (infos != null) {
                    tmvect = infos.getTModelInfoVector();
                }
                for (int i = 0; tmvect != null && i < tmvect.size(); ++i) {
                    TModelInfo info = (TModelInfo)tmvect.elementAt(i);
                    col.add(ScoutUddiJaxrHelper.getConcept(info, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager()));
                }
            }
            catch (RegistryException e) {
                log.error((Object)"RegistryException::", (Throwable)e);
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return new BulkResponseImpl(col);
    }

    public BulkResponse findRegistryPackages(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse findServiceBindings(Key serviceKey, Collection findQualifiers, Collection classifications, Collection specifications) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistry iRegistry = this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        try {
            BindingDetail l = iRegistry.findBinding(serviceKey.getId(), null, null, juddiFindQualifiers, this.registryService.getMaxRows());
            if (l != null) {
                Vector bindvect = l.getBindingTemplateVector();
                ArrayList<ServiceBinding> col = new ArrayList<ServiceBinding>();
                for (int i = 0; bindvect != null && i < bindvect.size(); ++i) {
                    BindingTemplate si = (BindingTemplate)bindvect.elementAt(i);
                    ServiceBinding sb = ScoutUddiJaxrHelper.getServiceBinding(si, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                    col.add(sb);
                    Service s = (Service)this.getRegistryObject(serviceKey.getId(), "Service");
                    ((ServiceBindingImpl)sb).setService(s);
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"RegistryException::", (Throwable)e);
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    public BulkResponse findServices(Key orgKey, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specificationa) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistry iRegistry = this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        Vector juddiNames = BusinessQueryManagerImpl.mapNamePatterns(namePatterns);
        try {
            ServiceList l;
            String id = null;
            if (orgKey != null) {
                id = orgKey.getId();
            }
            if ((l = iRegistry.findService(id, juddiNames, null, null, juddiFindQualifiers, this.registryService.getMaxRows())) != null) {
                ServiceInfos serviceInfos = l.getServiceInfos();
                Vector v = serviceInfos != null ? serviceInfos.getServiceInfoVector() : null;
                ArrayList<Service> col = new ArrayList<Service>();
                for (int i = 0; v != null && i < v.size(); ++i) {
                    ServiceInfo si = (ServiceInfo)v.elementAt(i);
                    col.add(ScoutUddiJaxrHelper.getService(si, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager()));
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"RegistryException::", (Throwable)e);
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    public RegistryObject getRegistryObject(String id) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public RegistryObject getRegistryObject(String id, String objectType) throws JAXRException {
        block17: {
            IRegistry registry = this.registryService.getRegistry();
            BusinessLifeCycleManager lcm = this.registryService.getBusinessLifeCycleManager();
            if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
                try {
                    TModelDetail tmodeldetail = registry.getTModelDetail(id);
                    if (tmodeldetail != null && tmodeldetail.getTModelVector().size() > 0) {
                        TModel tmodel = (TModel)tmodeldetail.getTModelVector().elementAt(0);
                        ClassificationSchemeImpl scheme = new ClassificationSchemeImpl((LifeCycleManager)lcm);
                        boolean uddiBased = this.isUDDIBasedTModel(tmodel);
                        if (uddiBased) {
                            scheme.setName(new InternationalStringImpl(tmodel.getName()));
                            Vector descVect = tmodel.getDescriptionVector();
                            if (descVect != null && descVect.size() > 0) {
                                Description d = (Description)descVect.elementAt(0);
                                scheme.setDescription(new InternationalStringImpl(d.getValue()));
                            }
                            scheme.setExternalLinks(ScoutUddiJaxrHelper.getExternalLinks(tmodel.getOverviewDoc(), (LifeCycleManager)lcm));
                            scheme.setExternalIdentifiers(ScoutUddiJaxrHelper.getExternalIdentifiers(tmodel.getIdentifierBag(), (LifeCycleManager)lcm));
                            scheme.setClassifications(ScoutUddiJaxrHelper.getClassifications(tmodel.getCategoryBag(), (LifeCycleManager)lcm));
                        } else {
                            Concept c = ScoutUddiJaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
                            scheme.setName(c.getName());
                            scheme.setDescription(c.getDescription());
                            scheme.setKey(c.getKey());
                        }
                        return scheme;
                    }
                    break block17;
                }
                catch (RegistryException e) {
                    log.error((Object)"RegistryException::", (Throwable)e);
                    throw new JAXRException(e.getLocalizedMessage());
                }
            }
            if ("Organization".equalsIgnoreCase(objectType)) {
                try {
                    BusinessDetail orgdetail = registry.getBusinessDetail(id);
                    return ScoutUddiJaxrHelper.getOrganization(orgdetail, (LifeCycleManager)lcm);
                }
                catch (RegistryException e) {
                    log.error((Object)"RegistryException::", (Throwable)e);
                    throw new JAXRException(e.getLocalizedMessage());
                }
            }
            if ("Concept".equalsIgnoreCase(objectType)) {
                try {
                    TModelDetail tmodeldetail = registry.getTModelDetail(id);
                    return ScoutUddiJaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
                }
                catch (RegistryException e) {
                    log.error((Object)"RegistryException::", (Throwable)e);
                    throw new JAXRException(e.getLocalizedMessage());
                }
            }
            if ("Service".equalsIgnoreCase(objectType)) {
                try {
                    Vector v;
                    ServiceDetail sd = registry.getServiceDetail(id);
                    if (sd != null && (v = sd.getBusinessServiceVector()).size() != 0) {
                        Service service = this.getServiceFromBusinessService((BusinessService)v.elementAt(0), (LifeCycleManager)lcm);
                        return service;
                    }
                }
                catch (RegistryException e) {
                    log.error((Object)"RegistryException::", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected Service getServiceFromBusinessService(BusinessService bs, LifeCycleManager lcm) throws JAXRException {
        Service service = ScoutUddiJaxrHelper.getService(bs, lcm);
        String busKey = bs.getBusinessKey();
        if (busKey != null) {
            Organization o = (Organization)this.getRegistryObject(busKey, "Organization");
            service.setProvidingOrganization(o);
        }
        return service;
    }

    public BulkResponse getRegistryObjects() throws JAXRException {
        String[] types = new String[]{"Organization", "Service"};
        ArrayList c = new ArrayList();
        for (int i = 0; i < types.length; ++i) {
            try {
                BulkResponse bk = this.getRegistryObjects(types[i]);
                if (bk.getCollection() == null) continue;
                c.addAll(bk.getCollection());
                continue;
            }
            catch (JAXRException e) {
                // empty catch block
            }
        }
        return new BulkResponseImpl(c);
    }

    public BulkResponse getRegistryObjects(Collection objectKeys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BulkResponse getRegistryObjects(Collection objectKeys, String objectType) throws JAXRException {
        IRegistry registry = this.registryService.getRegistry();
        Vector<String> keys = new Vector<String>();
        Iterator iter = objectKeys.iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            keys.add(key.getId());
        }
        ArrayList<Object> col = new ArrayList<Object>();
        BusinessLifeCycleManagerImpl lcm = this.registryService.getLifeCycleManagerImpl();
        if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(keys);
                Vector tmvect = tmodeldetail.getTModelVector();
                for (int i = 0; tmvect != null && i < tmvect.size(); ++i) {
                    col.add(ScoutUddiJaxrHelper.getConcept((TModel)tmvect.elementAt(i), (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                log.error((Object)"RegistryException::", (Throwable)e);
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Organization".equalsIgnoreCase(objectType)) {
            try {
                BusinessDetail orgdetail = registry.getBusinessDetail(keys);
                Vector bizvect = orgdetail.getBusinessEntityVector();
                for (int i = 0; bizvect != null && i < bizvect.size(); ++i) {
                    col.add(ScoutUddiJaxrHelper.getOrganization((BusinessEntity)bizvect.elementAt(i), (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Concept".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(keys);
                Vector tmvect = tmodeldetail.getTModelVector();
                for (int i = 0; tmvect != null && i < tmvect.size(); ++i) {
                    col.add(ScoutUddiJaxrHelper.getConcept((TModel)tmvect.elementAt(i), (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                log.error((Object)"RegistryException::", (Throwable)e);
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if (!"Service".equalsIgnoreCase(objectType)) throw new JAXRException("Unsupported type " + objectType + " for getRegistryObjects() in Apache Scout");
        try {
            ServiceDetail serviceDetail = registry.getServiceDetail(keys);
            if (serviceDetail == null) return new BulkResponseImpl(col);
            Vector v = serviceDetail.getBusinessServiceVector();
            for (int i = 0; v != null && i < v.size(); ++i) {
                Service service = this.getServiceFromBusinessService((BusinessService)v.elementAt(i), lcm);
                col.add(service);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse getRegistryObjects(String id) throws JAXRException {
        if ("Organization".equalsIgnoreCase(id)) {
            ArrayList<String> a = new ArrayList<String>();
            a.add("%");
            BulkResponse br = this.findOrganizations(null, a, null, null, null, null);
            return br;
        }
        if ("Service".equalsIgnoreCase(id)) {
            ArrayList<String> a = new ArrayList<String>();
            a.add("%");
            BulkResponse br = this.findServices(null, null, a, null, null);
            return br;
        }
        throw new JAXRException("Unsupported type for getRegistryObjects() :" + id);
    }

    static FindQualifiers mapFindQualifiers(Collection jaxrQualifiers) throws UnsupportedCapabilityException {
        if (jaxrQualifiers == null) {
            return null;
        }
        FindQualifiers result = new FindQualifiers(jaxrQualifiers.size());
        Iterator i = jaxrQualifiers.iterator();
        while (i.hasNext()) {
            String jaxrQualifier = (String)i.next();
            FindQualifier juddiQualifier = (FindQualifier)findQualifierMapping.get(jaxrQualifier);
            if (juddiQualifier == null) {
                throw new UnsupportedCapabilityException("jUDDI does not support FindQualifer: " + jaxrQualifier);
            }
            result.addFindQualifier(juddiQualifier);
        }
        return result;
    }

    static Vector mapNamePatterns(Collection namePatterns) throws JAXRException {
        if (namePatterns == null) {
            return null;
        }
        Vector<Name> result = new Vector<Name>(namePatterns.size());
        Iterator i = namePatterns.iterator();
        while (i.hasNext()) {
            Name name = null;
            Object obj = i.next();
            Locale locale = Locale.getDefault();
            if (obj instanceof String) {
                name = new Name((String)obj, locale.getLanguage());
            } else if (obj instanceof LocalizedString) {
                LocalizedString ls = (LocalizedString)obj;
                name = new Name(ls.getValue(), ls.getLocale().getLanguage());
            }
            result.add(name);
        }
        return result;
    }

    private AuthToken getAuthToken(ConnectionImpl connection, IRegistry ireg) throws JAXRException {
        Set creds = connection.getCredentials();
        Iterator it = creds.iterator();
        String username = "";
        String pwd = "";
        while (it.hasNext()) {
            PasswordAuthentication pass = (PasswordAuthentication)it.next();
            username = pass.getUserName();
            pwd = new String(pass.getPassword());
        }
        AuthToken token = null;
        try {
            token = ireg.getAuthToken(username, pwd);
        }
        catch (Exception e) {
            throw new JAXRException((Throwable)e);
        }
        return token;
    }

    private boolean isUDDIBasedTModel(TModel tmodel) {
        Vector vect;
        String uddi_org_types = "uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4";
        boolean result = false;
        CategoryBag cbag = tmodel.getCategoryBag();
        if (cbag != null && (vect = cbag.getKeyedReferenceVector()) != null) {
            Iterator iter = vect.iterator();
            while (iter.hasNext()) {
                KeyedReference kr = (KeyedReference)iter.next();
                if (kr == null) continue;
                String key = kr.getTModelKey();
                String tval = kr.getKeyValue();
                result = key.equals(uddi_org_types);
                result = this.checkTaxonomyValue(tval);
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    private boolean checkTaxonomyValue(String tval) {
        return tval.equalsIgnoreCase("Identifier") || tval.equalsIgnoreCase("Namespace") || tval.equalsIgnoreCase("Categorization") || tval.equalsIgnoreCase("PostalAddress");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        findQualifierMapping.put("andAllKeys", new FindQualifier("andAllKeys"));
        findQualifierMapping.put("caseSensitiveMatch", new FindQualifier("caseSensitiveMatch"));
        findQualifierMapping.put("combineClassifications", new FindQualifier("combineCategoryBags"));
        findQualifierMapping.put("exactNameMatch", new FindQualifier("exactNameMatch"));
        findQualifierMapping.put("orAllKeys", new FindQualifier("orAllKeys"));
        findQualifierMapping.put("orLikeKeys", new FindQualifier("orLikeKeys"));
        findQualifierMapping.put("serviceSubset", new FindQualifier("serviceSubset"));
        findQualifierMapping.put("sortByDateAsc", new FindQualifier("sortByDateAsc"));
        findQualifierMapping.put("sortByDateDesc", new FindQualifier("sortByDateDesc"));
        findQualifierMapping.put("sortByNameAsc", new FindQualifier("sortByNameAsc"));
        findQualifierMapping.put("sortByNameDesc", new FindQualifier("sortByNameDesc"));
    }
}

