/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.metadata;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.holders.Holder;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.metadata.ToolsEndpointMetaData;

public class ToolsAnnotationMetaDataBuilder {
    private ToolsEndpointMetaData tmd = null;
    private String targetNamespace = null;
    private String typeNamespace = null;
    private Class endpoint = null;

    public ToolsAnnotationMetaDataBuilder(ToolsEndpointMetaData tmd, String targetNamespace, String typeNamespace2) {
        this.tmd = tmd;
        this.targetNamespace = targetNamespace;
        this.typeNamespace = this.typeNamespace;
        this.endpoint = tmd.getServiceEndpointInterface();
    }

    public ToolsEndpointMetaData generate() {
        this.generateOperationMetaData();
        return this.tmd;
    }

    private void generateOperationMetaData() {
        Method[] marr = this.endpoint.getDeclaredMethods();
        if (marr != null) {
            int len = Array.getLength(marr);
            for (int i = 0; i < len; ++i) {
                Method m = marr[i];
                if (WSDLUtils.getInstance().checkIgnoreMethod(m)) continue;
                this.tmd.addOperation(this.getOperationMetaData(m, this.tmd));
            }
        }
    }

    private OperationMetaData getOperationMetaData(Method m, ToolsEndpointMetaData em) {
        Class<?>[] exarr;
        Class<?> ret;
        ParameterMetaData retPmd;
        String wsdlStyle;
        String opname = null;
        String soapAction = null;
        WebMethod an = m.getAnnotation(WebMethod.class);
        if (an != null) {
            opname = an.operationName();
            soapAction = an.action();
        }
        if (opname == null || opname.length() == 0) {
            opname = m.getName();
        }
        OperationMetaData om = new OperationMetaData(em, new QName(this.targetNamespace, opname), m.getName());
        om.setSOAPAction(soapAction);
        Style style = Style.RPC;
        SOAPBinding sb = this.endpoint.getAnnotation(SOAPBinding.class);
        if (sb != null && (wsdlStyle = sb.style().name()) != null && wsdlStyle.equalsIgnoreCase("DOCUMENT")) {
            style = Style.DOCUMENT;
        }
        em.setStyle(style);
        Class<?>[] paramTypes = m.getParameterTypes();
        int lenparam = paramTypes != null ? paramTypes.length : 0;
        for (int j = 0; j < lenparam; ++j) {
            Class<?> paramType = paramTypes[j];
            if (Remote.class.isAssignableFrom(paramType)) {
                throw new WSException("OpName:" + opname + " param:" + paramType.getName() + " should not extend Remote");
            }
            om.addParameter(this.getParameterMetaData(paramType, om, j + 1));
        }
        Oneway ow = m.getAnnotation(Oneway.class);
        if (ow != null) {
            om.setOneWayOperation(true);
        }
        if ((retPmd = this.getParameterMetaDataForReturnType(ret = m.getReturnType(), om, 1)) != null) {
            om.setReturnParameter(retPmd);
        }
        if ((exarr = m.getExceptionTypes()) != null) {
            int len = Array.getLength(exarr);
            int i = 0;
            for (i = 0; i < len; ++i) {
                Class<?> exClass = exarr[i];
                if (RemoteException.class.isAssignableFrom(exClass)) continue;
                om.addFault(this.getFaultMetaData(exClass, om));
            }
        }
        return om;
    }

    private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, int index) {
        WebParam wp = type.getAnnotation(WebParam.class);
        String tns = this.targetNamespace;
        String name = "";
        ParameterMode mode = ParameterMode.IN;
        if (wp != null) {
            tns = wp.targetNamespace();
            if (tns == null || tns == "") {
                tns = this.targetNamespace;
            }
            String string = name = wp.name() == "" ? type.getName() + "_" + index : type.getName();
            if (wp.mode() == WebParam.Mode.INOUT) {
                mode = ParameterMode.INOUT;
            } else if (wp.mode() == WebParam.Mode.OUT) {
                mode = ParameterMode.OUT;
            }
        }
        if (name == null || name.length() == 0) {
            name = this.getXMLName(type) + "_" + index;
        }
        if (this.typeNamespace != null && !this.typeNamespace.equals(tns)) {
            tns = this.typeNamespace;
        }
        boolean header = wp != null ? wp.header() : false;
        QName xmlType = ToolsUtils.getXMLType(type, tns);
        ParameterMetaData pm = new ParameterMetaData(om, new QName(tns, name), xmlType, type.getName());
        return pm;
    }

    private ParameterMetaData getParameterMetaDataForReturnType(Class type, OperationMetaData om, int index) {
        if (type == Void.TYPE) {
            return null;
        }
        if (Remote.class.isAssignableFrom(type)) {
            throw new WSException(om.getJavaName() + " has return type which " + "should not extend java.rmi.Remote");
        }
        WebResult wr = type.getAnnotation(WebResult.class);
        String tns = this.targetNamespace;
        String name = "result";
        if (wr != null) {
            tns = wr.targetNamespace();
            if (tns == null || tns == "") {
                tns = this.targetNamespace;
            }
            name = wr.name() == "" ? type.getName() + "_" + index : type.getName();
        } else if (Holder.class.isAssignableFrom(type)) {
            type = WSDLUtils.getInstance().getJavaTypeForHolder(type);
        }
        if (this.typeNamespace != null && !tns.equals(this.typeNamespace)) {
            tns = this.typeNamespace;
        }
        QName xmlType = ToolsUtils.getXMLType(type, tns);
        ParameterMetaData pm = new ParameterMetaData(om, new QName(tns, name), xmlType, type.getName());
        return pm;
    }

    private FaultMetaData getFaultMetaData(Class exType, OperationMetaData om) {
        String exname = WSDLUtils.getInstance().getJustClassName(exType);
        QName xmlName = new QName(this.typeNamespace, exname);
        FaultMetaData fm = new FaultMetaData(om, xmlName, xmlName, exType.getName());
        return fm;
    }

    private String getXMLName(Class javaClass) {
        String name = "";
        WSDLUtils utils = WSDLUtils.getInstance();
        if (Holder.class.isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        if (javaClass.isArray()) {
            int len = utils.getArrayDimension(javaClass);
            for (int i = 0; i < len; ++i) {
                javaClass = javaClass.getComponentType();
            }
            name = utils.getMessagePartForArray(javaClass);
        } else {
            name = utils.getJustClassName(javaClass);
        }
        return name;
    }
}

