/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.soap.SOAPMessageDispatcher;
import org.jboss.ws.soap.SOAPPartImpl;
import org.jboss.ws.soap.attachment.AttachmentPartImpl;
import org.jboss.ws.soap.attachment.CIDGenerator;
import org.jboss.ws.soap.attachment.MultipartRelatedEncoder;
import org.jboss.ws.soap.attachment.MultipartRelatedSwAEncoder;
import org.jboss.ws.soap.attachment.MultipartRelatedXOPEncoder;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageImpl
extends SOAPMessage {
    private boolean saveRequired = true;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private List<AttachmentPart> attachments = new LinkedList<AttachmentPart>();
    private CIDGenerator cidGenerator = new CIDGenerator();
    private boolean isXOPMessage;
    private SOAPPartImpl soapPart = new SOAPPartImpl(this);
    private MultipartRelatedEncoder multipartRelatedEncoder;
    private OperationMetaData opMetaData;

    SOAPMessageImpl() throws SOAPException {
        this.setProperty("javax.xml.soap.character-set-encoding", "UTF-8");
        this.setProperty("javax.xml.soap.write-xml-declaration", false);
    }

    public CIDGenerator getCidGenerator() {
        return this.cidGenerator;
    }

    public boolean isXOPMessage() {
        return this.isXOPMessage;
    }

    public void setXOPMessage(boolean isXOPMessage) {
        this.isXOPMessage = isXOPMessage;
    }

    public void setAttachments(Collection<AttachmentPart> parts) throws SOAPException {
        for (AttachmentPart part : parts) {
            this.attachments.add(part);
        }
        this.saveRequired = true;
    }

    public void addAttachmentPart(AttachmentPart part) {
        if (part == null) {
            return;
        }
        this.attachments.add(part);
        this.saveRequired = true;
    }

    public AttachmentPart getAttachmentByContentId(String cid) throws SOAPException {
        for (AttachmentPart part : this.attachments) {
            String contentId = part.getContentId();
            if (!contentId.equals(cid)) continue;
            return part;
        }
        return null;
    }

    public AttachmentPart getAttachmentByPartName(String partName) {
        for (AttachmentPart part : this.attachments) {
            String contentId = part.getContentId();
            if (!contentId.startsWith("<" + partName + "=")) continue;
            return part;
        }
        return null;
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public String getContentDescription() {
        String[] value = this.mimeHeaders.getHeader("Content-Description");
        return value == null ? null : value[0];
    }

    public void setContentDescription(String description) {
        this.mimeHeaders.setHeader("Content-Description", description);
    }

    public MimeHeaders getMimeHeaders() {
        return this.mimeHeaders;
    }

    public void setMimeHeaders(MimeHeaders headers) {
        if (headers == null) {
            throw new IllegalArgumentException("MimeHeaders cannot be null");
        }
        this.mimeHeaders = headers;
    }

    public SOAPPart getSOAPPart() {
        return this.soapPart;
    }

    public void removeAllAttachments() {
        this.attachments.clear();
        this.saveRequired = true;
    }

    public int countAttachments() {
        return this.attachments.size();
    }

    public Iterator getAttachments() {
        this.saveRequired = true;
        return this.attachments.iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        if (headers == null) {
            throw new WSException("MimeHeaders can not be null");
        }
        return new MimeMatchingAttachmentsIterator(headers, this.attachments);
    }

    public void saveChanges() throws SOAPException {
        if (this.saveRequired) {
            try {
                String contentType;
                if (this.isXOPMessage()) {
                    this.multipartRelatedEncoder = new MultipartRelatedXOPEncoder(this);
                    this.multipartRelatedEncoder.encodeMultipartRelatedMessage();
                    contentType = this.multipartRelatedEncoder.getContentType();
                } else if (this.attachments.size() > 0) {
                    this.multipartRelatedEncoder = new MultipartRelatedSwAEncoder(this);
                    this.multipartRelatedEncoder.encodeMultipartRelatedMessage();
                    contentType = this.multipartRelatedEncoder.getContentType();
                } else {
                    contentType = "text/xml; charset=" + this.getCharSetEncoding();
                }
                this.mimeHeaders.setHeader("Content-Type", contentType);
            }
            catch (MessagingException ex) {
                throw new SOAPException((Throwable)ex);
            }
            this.saveRequired = false;
        }
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public void writeTo(OutputStream outs) throws SOAPException, IOException {
        this.saveChanges();
        if (this.attachments.size() > 0) {
            this.multipartRelatedEncoder.writeTo(outs);
        } else {
            SOAPEnvelope soapEnv = this.getSOAPPart().getEnvelope();
            if (soapEnv != null) {
                boolean writeXML = this.isWriteXMLDeclaration();
                String charsetEncoding = this.getCharSetEncoding();
                DOMWriter domWriter = new DOMWriter(outs, charsetEncoding);
                domWriter.setWriteXMLDeclaration(writeXML).print((Node)soapEnv);
            }
        }
    }

    private String getCharSetEncoding() throws SOAPException {
        String charsetName = (String)this.getProperty("javax.xml.soap.character-set-encoding");
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        return charsetName;
    }

    public OperationMetaData getOperationMetaData(EndpointMetaData epMetaData) throws SOAPException {
        if (this.opMetaData == null) {
            SOAPMessageDispatcher dispatcher = new SOAPMessageDispatcher();
            this.opMetaData = dispatcher.getDispatchDestination(epMetaData, this);
        }
        return this.opMetaData;
    }

    public boolean isFaultMessage() {
        SOAPFault soapFault = null;
        try {
            soapFault = this.getSOAPBody().getFault();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return soapFault != null;
    }

    private boolean isWriteXMLDeclaration() throws SOAPException {
        Boolean booleanValue = new Boolean(false);
        Object propValue = this.getProperty("javax.xml.soap.write-xml-declaration");
        if (propValue instanceof Boolean) {
            booleanValue = (Boolean)propValue;
        }
        if (propValue instanceof String) {
            booleanValue = new Boolean((String)propValue);
        }
        return booleanValue;
    }

    public static class MimeMatchingAttachmentsIterator
    implements Iterator {
        private Iterator iterator;
        private MimeHeaders headers = new MimeHeaders();
        private AttachmentPart lastMatch;

        public MimeMatchingAttachmentsIterator(MimeHeaders headers, List attachments) {
            this.iterator = attachments.iterator();
            if (headers != null) {
                this.headers = headers;
            }
        }

        private boolean containsAllHeaders(Iterator headerIterator, AttachmentPart part) {
            while (headerIterator.hasNext()) {
                MimeHeader header = (MimeHeader)headerIterator.next();
                String[] values = part.getMimeHeader(header.getName());
                if (values == null) {
                    return false;
                }
                boolean match = false;
                for (int j = 0; j < values.length; ++j) {
                    if (!values[j].equalsIgnoreCase(header.getValue())) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }

        private void nextMatch() {
            while (this.iterator.hasNext()) {
                AttachmentPart part = (AttachmentPart)this.iterator.next();
                if (!this.containsAllHeaders(this.headers.getAllHeaders(), part)) continue;
                this.lastMatch = part;
                break;
            }
        }

        public boolean hasNext() {
            if (this.lastMatch == null) {
                this.nextMatch();
            }
            return this.lastMatch != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            AttachmentPart retval = this.lastMatch;
            this.lastMatch = null;
            return retval;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

