/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xmlschema;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXSEntityResolver
implements XMLEntityResolver {
    private static final Logger log = Logger.getLogger(JBossXSEntityResolver.class);
    private Map<String, URL> schemaLocationByNamespace = new HashMap<String, URL>();
    private JBossEntityResolver resolver = new JBossEntityResolver();

    public JBossXSEntityResolver(Map<String, URL> schemaLocationByNamespace) {
        this.schemaLocationByNamespace = schemaLocationByNamespace;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resId) throws XNIException, IOException {
        String namespaceURI;
        log.trace((Object)("Resolve entity: " + resId));
        try {
            String expandedSysId = resId.getExpandedSystemId();
            if (expandedSysId != null) {
                log.trace((Object)("Use ExpandedSystemId: " + expandedSysId));
                return this.getXMLInputSource(new URL(expandedSysId), resId);
            }
        }
        catch (IOException e) {
            log.trace((Object)e);
        }
        try {
            String literalSysId = resId.getLiteralSystemId();
            if (literalSysId != null) {
                log.trace((Object)("Use LiteralSystemId: " + literalSysId));
                return this.getXMLInputSource(new URL(literalSysId), resId);
            }
        }
        catch (IOException e) {
            log.trace((Object)e);
        }
        String string = namespaceURI = resId.getNamespace() != null ? resId.getNamespace() : resId.getLiteralSystemId();
        if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
            return null;
        }
        try {
            URL url = this.schemaLocationByNamespace.get(namespaceURI);
            if (url != null) {
                log.trace((Object)("Use SchemaLocationByNamespace: " + url));
                return this.getXMLInputSource(url, resId);
            }
            XMLInputSource source = this.getXMLInputSource(this.resolver.resolveEntity(null, namespaceURI), resId);
            if (source != null) {
                return source;
            }
        }
        catch (SAXException e) {
            log.trace((Object)e);
        }
        try {
            log.trace((Object)("Use NamespaceURI: " + namespaceURI));
            return this.getXMLInputSource(new URL(namespaceURI), resId);
        }
        catch (IOException e) {
            log.trace((Object)e);
            log.trace((Object)("Cannot obtain XMLInputSource for: " + resId));
            return null;
        }
    }

    private XMLInputSource getXMLInputSource(URL url, XMLResourceIdentifier resId) throws IOException {
        InputStream inputStream = url.openStream();
        InputSource inputSource = new InputSource(inputStream);
        return this.getXMLInputSource(inputSource, resId);
    }

    private XMLInputSource getXMLInputSource(InputSource inputSource, XMLResourceIdentifier resId) {
        String encoding = inputSource.getEncoding();
        InputStream byteStream = inputSource.getByteStream();
        return new XMLInputSource(resId.getPublicId(), resId.getExpandedSystemId(), resId.getBaseSystemId(), byteStream, encoding);
    }
}

