/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDL11Writer;
import org.jboss.ws.metadata.wsdl.WSDL20Writer;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLImport;
import org.jboss.ws.metadata.wsdl.WSDLInclude;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Document;

public class WSDLDefinitions
implements Serializable {
    private static final long serialVersionUID = 1643422922694990226L;
    private final Logger log = Logger.getLogger(WSDLDefinitions.class);
    private String targetNamespace;
    private String wsdlNamespace;
    private List<WSDLImport> imports = new ArrayList<WSDLImport>();
    private List<WSDLInclude> includes = new ArrayList<WSDLInclude>();
    private WSDLTypes types;
    private Map<NCName, WSDLInterface> interfaces = new LinkedHashMap<NCName, WSDLInterface>();
    private Map<NCName, WSDLBinding> bindings = new LinkedHashMap<NCName, WSDLBinding>();
    private Map<NCName, WSDLService> services = new LinkedHashMap<NCName, WSDLService>();
    private NamespaceRegistry namespaces = new NamespaceRegistry();
    private Definition wsdlOneOneDefinition;
    private Document wsdlDocument;

    public void setWsdlOneOneDefinition(Definition wsdlDefinition) {
        this.wsdlOneOneDefinition = wsdlDefinition;
    }

    public Definition getWsdlOneOneDefinition() {
        return this.wsdlOneOneDefinition;
    }

    public Document getWsdlDocument() {
        return this.wsdlDocument;
    }

    public void setWsdlDocument(Document wsdlDocument) {
        this.wsdlDocument = wsdlDocument;
    }

    public String registerNamespaceURI(String nsURI, String prefix) {
        String pre = this.namespaces.getPrefix(nsURI);
        if (pre == null || pre == "") {
            pre = this.namespaces.registerURI(nsURI, prefix);
            this.log.trace((Object)("registerNamespaceURI: " + pre + "=" + nsURI));
        }
        return pre;
    }

    public QName registerQName(QName qname) {
        return this.namespaces.registerQName(qname);
    }

    public String getPrefix(String namespaceURI) {
        return this.namespaces.getPrefix(namespaceURI);
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaces.getNamespaceURI(prefix);
    }

    public String getTargetPrefix() {
        return this.namespaces.getPrefix(this.targetNamespace);
    }

    public Iterator getRegisteredNamespaceURIs() {
        return this.namespaces.getRegisteredURIs();
    }

    public Iterator getRegisteredPrefix() {
        return this.namespaces.getRegisteredPrefixes();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Illegal Null Argument:namespaceURI");
        }
        this.log.trace((Object)("setTargetNamespace: " + namespaceURI));
        this.targetNamespace = namespaceURI;
    }

    public String getWsdlNamespace() {
        return this.wsdlNamespace;
    }

    public void setWsdlNamespace(String namespaceURI) {
        if (!"http://schemas.xmlsoap.org/wsdl/".equals(namespaceURI) && !"http://www.w3.org/2003/11/wsdl".equals(namespaceURI)) {
            throw new IllegalArgumentException("Invalid default namespace: " + namespaceURI);
        }
        this.wsdlNamespace = namespaceURI;
    }

    public WSDLImport[] getImports() {
        WSDLImport[] arr = new WSDLImport[this.imports.size()];
        this.imports.toArray(arr);
        return arr;
    }

    public void addImport(WSDLImport anImport) {
        this.imports.add(anImport);
    }

    public WSDLInclude[] getIncludes() {
        WSDLInclude[] arr = new WSDLInclude[this.includes.size()];
        this.includes.toArray(arr);
        return arr;
    }

    public void addInclude(WSDLInclude include) {
        this.includes.add(include);
    }

    public WSDLTypes getWsdlTypes() {
        if (this.types == null) {
            this.types = new WSDLTypes(this);
        }
        return this.types;
    }

    public void setWsdlTypes(WSDLTypes types) {
        this.types = types;
    }

    public WSDLInterface getInterface(NCName ncName) {
        return this.interfaces.get(ncName);
    }

    public WSDLInterface[] getInterfaces() {
        WSDLInterface[] arr = new WSDLInterface[this.interfaces.size()];
        new ArrayList<WSDLInterface>(this.interfaces.values()).toArray(arr);
        return arr;
    }

    public void addInterface(WSDLInterface wsdlInterface) {
        this.interfaces.put(wsdlInterface.getName(), wsdlInterface);
    }

    public WSDLBinding[] getBindings() {
        WSDLBinding[] arr = new WSDLBinding[this.bindings.size()];
        new ArrayList<WSDLBinding>(this.bindings.values()).toArray(arr);
        return arr;
    }

    public WSDLBinding getBinding(NCName ncName) {
        return this.bindings.get(ncName);
    }

    public WSDLBinding getBindingByInterfaceName(QName qname) {
        WSDLBinding wsdlBinding = null;
        for (WSDLBinding aux : this.bindings.values()) {
            if (!aux.getInterfaceName().equals(qname)) continue;
            if (wsdlBinding != null) {
                this.log.warn((Object)("Multiple WSDL bindings referrence the same interface: " + qname));
            }
            wsdlBinding = aux;
        }
        return wsdlBinding;
    }

    public void addBinding(WSDLBinding binding) {
        this.bindings.put(binding.getName(), binding);
    }

    public WSDLService[] getServices() {
        WSDLService[] arr = new WSDLService[this.services.size()];
        new ArrayList<WSDLService>(this.services.values()).toArray(arr);
        return arr;
    }

    public void addService(WSDLService service) {
        this.services.put(service.getName(), service);
    }

    public WSDLService getService(NCName name) {
        return this.services.get(name);
    }

    public void unRegisterNamespaceURI(String namespaceURI, String prefix) {
        String pre = this.namespaces.getPrefix(namespaceURI);
        if (pre != null && pre.equals(prefix)) {
            this.namespaces.removePrefixMapping(prefix);
        }
    }

    public void write(Writer writer, String charset) throws IOException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(this.wsdlNamespace)) {
            WSDL11Writer wsdl11Writer = new WSDL11Writer(this);
            wsdl11Writer.write(writer, charset);
        } else if ("http://www.w3.org/2003/11/wsdl".equals(this.wsdlNamespace)) {
            WSDL20Writer wsdl20Writer = new WSDL20Writer(this);
            wsdl20Writer.write(writer);
        } else {
            throw new WSException("Unsupported wsdl version: " + this.wsdlNamespace);
        }
    }
}

