/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedMetaData {
    private URLClassLoader resourceLoader;
    private ClassLoader classLoader;
    private String securityDomain;
    Map<String, WSDLDefinitions> wsdlMap = new HashMap<String, WSDLDefinitions>();
    Map<String, JavaWsdlMapping> jaxrpcMap = new HashMap<String, JavaWsdlMapping>();
    private List<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
    private boolean initialized = false;

    public UnifiedMetaData() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public URLClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(URLClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public List<ServiceMetaData> getServices() {
        return new ArrayList<ServiceMetaData>(this.services);
    }

    public void addService(ServiceMetaData serviceMetaData) {
        this.services.add(serviceMetaData);
    }

    public void addWSDLDefinition(String wsdlFile, WSDLDefinitions wsdlDefinitions) {
        this.wsdlMap.put(wsdlFile, wsdlDefinitions);
    }

    public WSDLDefinitions getWSDLDefinition(String wsdlFile) {
        return this.wsdlMap.get(wsdlFile);
    }

    public void addMappingDefinition(String jaxrpcFile, JavaWsdlMapping javaWsdlMapping) {
        this.jaxrpcMap.put(jaxrpcFile, javaWsdlMapping);
    }

    public JavaWsdlMapping getMappingDefinition(String jaxrpcFile) {
        return this.jaxrpcMap.get(jaxrpcFile);
    }

    public void eagerInitialize() {
        if (!this.initialized) {
            for (ServiceMetaData service : this.services) {
                service.eagerInitialize();
            }
            this.initialized = true;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nUnifiedMetaData: ");
        buffer.append("\n securityDomain: " + this.securityDomain);
        buffer.append("\n");
        for (ServiceMetaData serviceMetaData : this.services) {
            buffer.append("\n" + serviceMetaData);
        }
        return buffer.toString();
    }
}

