/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.ExtensibleMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.JavaUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationMetaData
extends ExtensibleMetaData {
    private final Logger log = Logger.getLogger(OperationMetaData.class);
    private EndpointMetaData endpoint;
    private QName xmlName;
    private QName responseName;
    private String javaName;
    private Method javaMethod;
    private boolean oneWayOperation;
    private String soapAction;
    private List<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
    private List<FaultMetaData> faults = new ArrayList<FaultMetaData>();
    private ParameterMetaData returnParam;

    public OperationMetaData(QName xmlName, String javaName) {
        UnifiedMetaData umd = new UnifiedMetaData();
        ServiceMetaData smd = new ServiceMetaData(umd, new QName("mock-service"));
        ServerEndpointMetaData epmd = new ServerEndpointMetaData(smd, new QName("mock-endpoint"));
        this.initOperationMetaData(epmd, xmlName, javaName);
    }

    public OperationMetaData(EndpointMetaData epMetaData, QName xmlName, String javaName) {
        this.log.trace((Object)("new OperationMetaData: [xmlName=" + xmlName + ",javaName=" + javaName + "]"));
        this.initOperationMetaData(epMetaData, xmlName, javaName);
    }

    private void initOperationMetaData(EndpointMetaData epMetaData, QName xmlName, String javaName) {
        this.endpoint = epMetaData;
        this.xmlName = xmlName;
        this.javaName = javaName;
        if (xmlName == null) {
            throw new IllegalArgumentException("Invalid null xmlName argument");
        }
        if (javaName == null) {
            throw new IllegalArgumentException("Invalid null javaName argument, for: " + xmlName);
        }
        String nsURI = xmlName.getNamespaceURI();
        String localPart = xmlName.getLocalPart();
        this.responseName = new QName(nsURI, localPart + "Response");
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.endpoint;
    }

    public QName getXmlName() {
        return this.xmlName;
    }

    public QName getResponseName() {
        return this.responseName;
    }

    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSOAPAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public Style getStyle() {
        return this.endpoint.getStyle();
    }

    public Use getUse() {
        return this.endpoint.getEncodingStyle();
    }

    public ParameterStyle getParameterStyle() {
        return this.endpoint.getParameterStyle();
    }

    public boolean isRPCLiteral() {
        return this.getStyle() == Style.RPC && this.getUse() == Use.LITERAL;
    }

    public boolean isDocumentBare() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == ParameterStyle.BARE;
    }

    public boolean isDocumentWrapped() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == ParameterStyle.WRAPPED;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public Method getJavaMethod() {
        ClassLoader loader = this.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().getClassLoader();
        if (this.javaMethod == null || !this.javaMethod.getDeclaringClass().getClassLoader().equals(loader)) {
            this.javaMethod = null;
            try {
                Class seiClass = this.endpoint.getServiceEndpointInterface();
                if (seiClass == null) {
                    throw new WSException("ServiceEndpointInterface not available");
                }
                for (Method method : seiClass.getMethods()) {
                    String methodName = method.getName();
                    Class[] methodTypes = method.getParameterTypes();
                    if (!this.javaName.equals(methodName)) continue;
                    this.log.debug((Object)("Found java method: " + method));
                    if (this.isDocumentWrapped() && ParameterWrapping.matchRequestParameters(this, methodTypes)) {
                        this.log.debug((Object)("Found wrapped java method: " + method));
                        this.javaMethod = method;
                        break;
                    }
                    if (this.compareMethodParams(methodTypes, true)) {
                        this.log.debug((Object)("Found best matching java method: " + method));
                        this.javaMethod = method;
                        break;
                    }
                    if (!this.compareMethodParams(methodTypes, false)) continue;
                    if (this.javaMethod != null) {
                        throw new WSException("Umbiguous javaMethod: " + method);
                    }
                    this.log.debug((Object)("Found possible matching java method: " + method));
                    this.javaMethod = method;
                    break;
                }
                if (this.javaMethod == null) {
                    throw new WSException("Cannot find java method: " + this.javaName);
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WSException("Cannot load java method: " + this.javaName);
            }
        }
        return this.javaMethod;
    }

    public boolean isMessageEndpoint() {
        ParameterMetaData inParam;
        boolean isMessageEndpoint = false;
        if (this.parameters.size() == 1 && JavaUtils.isAssignableFrom(Element.class, (inParam = this.parameters.get(0)).getJavaType())) {
            isMessageEndpoint = true;
        }
        return isMessageEndpoint;
    }

    private boolean compareMethodParams(Class[] methodTypes, boolean matchByTypeName) {
        boolean pass;
        this.log.debug((Object)("Compare method params by type name: " + matchByTypeName));
        boolean bl = pass = this.parameters.size() == methodTypes.length;
        if (!pass) {
            this.log.debug((Object)("Unmatched parameter count: " + this.parameters.size() + "!=" + methodTypes.length));
        }
        for (int i = 0; pass && i < methodTypes.length; ++i) {
            ParameterMetaData paramMetaData = this.parameters.get(i);
            Class methodType = methodTypes[i];
            if (paramMetaData.getMode() != ParameterMode.IN) {
                if (HolderUtils.isHolderType(methodType)) {
                    methodType = HolderUtils.getValueType(methodType);
                } else {
                    pass = false;
                    break;
                }
            }
            if (matchByTypeName) {
                String javaTypeName = methodType.getName();
                String paramTypeName = paramMetaData.getJavaTypeName();
                pass = javaTypeName.equals(paramTypeName);
            } else {
                Class paramType = paramMetaData.getJavaType();
                pass = JavaUtils.isAssignableFrom(methodType, paramType);
            }
            String name = matchByTypeName ? paramMetaData.getJavaTypeName() : paramMetaData.getJavaType().getName();
            this.log.debug((Object)((pass ? "Matched" : "Unmatched") + " parameter: " + name + " == " + methodType.getName()));
        }
        return pass;
    }

    public boolean isOneWayOperation() {
        return this.oneWayOperation;
    }

    public void setOneWayOperation(boolean oneWayOperation) {
        this.oneWayOperation = oneWayOperation;
        this.assertOneWayOperation();
    }

    public ParameterMetaData getParameter(QName xmlName) {
        ParameterMetaData paramMetaData = null;
        for (int i = 0; paramMetaData == null && i < this.parameters.size(); ++i) {
            ParameterMetaData aux = this.parameters.get(i);
            if (!xmlName.equals(aux.getXmlName())) continue;
            paramMetaData = aux;
        }
        return paramMetaData;
    }

    public List<ParameterMetaData> getInputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.IN && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getOutputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.OUT && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getNonHeaderParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            if (paramMetaData.isInHeader()) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getParameters() {
        return new ArrayList<ParameterMetaData>(this.parameters);
    }

    public void addParameter(ParameterMetaData pmd) {
        this.log.trace((Object)("addParameter: [xmlName=" + pmd.getXmlName() + ",xmlType=" + pmd.getXmlType() + "]"));
        this.parameters.add(pmd);
        this.assertOneWayOperation();
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public ParameterMetaData getReturnParameter() {
        return this.returnParam;
    }

    public void setReturnParameter(ParameterMetaData returnParam) {
        this.log.trace((Object)("setReturnParameter: " + returnParam));
        returnParam.setMode(ParameterMode.OUT);
        this.returnParam = returnParam;
        this.assertOneWayOperation();
    }

    public List<FaultMetaData> getFaults() {
        return new ArrayList<FaultMetaData>(this.faults);
    }

    public FaultMetaData getFault(QName xmlName) {
        FaultMetaData faultMetaData = null;
        for (int i = 0; faultMetaData == null && i < this.faults.size(); ++i) {
            FaultMetaData aux = this.faults.get(i);
            if (!aux.getXmlName().equals(xmlName)) continue;
            faultMetaData = aux;
        }
        return faultMetaData;
    }

    public FaultMetaData getFault(Class javaType) {
        FaultMetaData faultMetaData = null;
        for (FaultMetaData aux : this.faults) {
            if (!aux.getJavaType().equals(javaType)) continue;
            faultMetaData = aux;
            break;
        }
        return faultMetaData;
    }

    public void addFault(FaultMetaData fault) {
        this.log.trace((Object)("addFault: " + fault));
        this.faults.add(fault);
        this.assertOneWayOperation();
    }

    public void validate() {
        this.assertBare();
    }

    private void assertOneWayOperation() {
        if (this.oneWayOperation) {
            if (this.returnParam != null) {
                throw new WSException("OneWay operations cannot have a return parameter");
            }
            if (this.faults.size() > 0) {
                throw new WSException("OneWay operations cannot have checked exceptions");
            }
            for (ParameterMetaData paramMetaData : this.parameters) {
                if (paramMetaData.getMode() == ParameterMode.IN) continue;
                throw new WSException("OneWay operations cannot have INOUT or OUT parameters");
            }
        }
    }

    private void assertBare() {
        if (this.isDocumentBare()) {
            int in = 0;
            int out = 0;
            for (ParameterMetaData paramMetaData : this.parameters) {
                if (paramMetaData.isInHeader()) continue;
                ParameterMode mode = paramMetaData.getMode();
                if (mode != ParameterMode.OUT) {
                    ++in;
                }
                if (mode == ParameterMode.IN) continue;
                ++out;
            }
            if (this.returnParam != null && !this.returnParam.isInHeader()) {
                ++out;
            }
            if (!(this.oneWayOperation && in == 1 && out == 0 || in == 1 && out == 1)) {
                throw new WSException("The body of a documnet/literal bare message requires only 1 input and only 1 output (or 0 if oneway). method: " + this.javaName + " in: " + in + " out: " + out);
            }
        }
    }

    public void eagerInitialize() {
        for (ParameterMetaData parameter : this.parameters) {
            parameter.eagerInitialize();
        }
        if (this.returnParam != null) {
            this.returnParam.eagerInitialize();
        }
        for (FaultMetaData fault : this.faults) {
            fault.eagerInitialize();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nOperationMetaData:");
        buffer.append("\n xmlName=" + this.xmlName);
        buffer.append("\n javaName=" + this.javaName);
        buffer.append("\n style=" + this.getStyle() + "/" + this.getUse() + (this.getStyle() == Style.DOCUMENT ? "/" + this.getParameterStyle() : ""));
        buffer.append("\n oneWay=" + this.oneWayOperation);
        buffer.append("\n soapAction=" + this.soapAction);
        for (ParameterMetaData param : this.parameters) {
            buffer.append(param);
        }
        if (this.returnParam != null) {
            buffer.append(this.returnParam.toString());
        }
        for (FaultMetaData fault : this.faults) {
            buffer.append(fault);
        }
        return buffer.toString();
    }
}

