/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.MatcherStrategy;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAll;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ClassExpression;

public class MethodMatcher
extends MatcherHelper {
    protected Advisor advisor;
    protected CtMethod ctMethod;
    protected Method refMethod;
    protected int methodModifiers;
    protected String classname;
    protected String methodName;
    protected boolean matchOnAdvisor;

    public MethodMatcher(Advisor advisor, CtMethod method, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.start = start;
        this.methodModifiers = method.getModifiers();
        this.classname = method.getDeclaringClass().getName();
        this.ctMethod = method;
        this.methodName = this.ctMethod.getName();
    }

    public MethodMatcher(Advisor advisor, Method method, ASTStart start, boolean matchOnAdvisor) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.start = start;
        this.methodModifiers = method.getModifiers();
        this.classname = method.getDeclaringClass().getName();
        this.refMethod = method;
        this.methodName = this.refMethod.getName();
        this.matchOnAdvisor = matchOnAdvisor;
    }

    public MethodMatcher(Advisor advisor, Method method, ASTStart start) {
        this(advisor, method, start, false);
    }

    protected Boolean resolvePointcut(Pointcut p) {
        throw new RuntimeException("SHOULD NOT BE CALLED");
    }

    public Object visit(ASTMethod node, Object data) {
        return this.matches(node);
    }

    public Boolean matches(ASTMethod node) {
        if (!this.matchesModifiers(node)) {
            return Boolean.FALSE;
        }
        if (!this.matchesClass(node)) {
            return Boolean.FALSE;
        }
        if (!this.matchesIdentifier(node)) {
            return Boolean.FALSE;
        }
        if (!this.matchesExceptions(node)) {
            return Boolean.FALSE;
        }
        if (!this.matchesReturnType(node)) {
            return Boolean.FALSE;
        }
        if (!this.matchesParameters(node)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(ASTAll node, Object data) {
        block20: {
            if (node.getClazz().isAnnotation()) {
                String sub = node.getClazz().getOriginal().substring(1);
                if (this.ctMethod != null) {
                    if (!(this.advisor.getMethodMetaData().hasGroup(this.ctMethod, sub) || this.advisor.getDefaultMetaData().hasTag(sub) || this.advisor.hasAnnotation(this.ctMethod, sub))) {
                        return Boolean.FALSE;
                    }
                } else if (!this.advisor.getMethodMetaData().hasTag(this.refMethod, sub) && !this.advisor.getDefaultMetaData().hasTag(sub)) {
                    try {
                        if (!this.advisor.hasAnnotation(this.refMethod, sub)) {
                            return Boolean.FALSE;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (node.getClazz().isInstanceOf()) {
                if (this.ctMethod != null ? !Util.subtypeOf(this.ctMethod.getDeclaringClass(), node.getClazz()) : !Util.subtypeOf(this.refMethod.getDeclaringClass(), node.getClazz(), this.advisor)) {
                    return Boolean.FALSE;
                }
            } else if (node.getClazz().isTypedef()) {
                if (this.ctMethod != null) {
                    try {
                        if (!Util.matchesTypedef(this.ctMethod.getDeclaringClass(), node.getClazz(), this.advisor)) {
                            return Boolean.FALSE;
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!Util.matchesTypedef(this.refMethod.getDeclaringClass(), node.getClazz(), this.advisor)) {
                    return Boolean.FALSE;
                }
            } else if (!node.getClazz().matches(this.classname)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected boolean matchesModifiers(ASTMethod node) {
        if (node.getAttributes().size() > 0) {
            for (int i = 0; i < node.getAttributes().size(); ++i) {
                ASTAttribute attr = (ASTAttribute)node.getAttributes().get(i);
                if (Util.matchModifiers(attr, this.methodModifiers)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean matchesClass(ASTMethod node) {
        if (this.ctMethod != null) {
            if (!Util.matchesClassExpr(node.getClazz(), this.ctMethod.getDeclaringClass(), this.advisor)) {
                return false;
            }
        } else {
            Class declaringClass = MatcherStrategy.getMatcher(this.advisor).getDeclaringClass(this.advisor, this.refMethod);
            Class advisedClass = this.advisor.getClazz();
            if (!Util.matchesClassExpr(node.getClazz(), declaringClass, this.advisor)) {
                if (declaringClass.equals(advisedClass)) {
                    return false;
                }
                if (this.matchOnAdvisor) {
                    if (!Util.matchesClassExpr(node.getClazz(), advisedClass, this.advisor)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean matchesIdentifier(ASTMethod node) {
        if (node.getMethodIdentifier().isAnnotation()) {
            if (this.advisor == null) {
                return false;
            }
            String sub = node.getMethodIdentifier().getOriginal().substring(1);
            if (this.ctMethod != null) {
                if (!(this.advisor.getMethodMetaData().hasGroup(this.ctMethod, sub) || this.advisor.getDefaultMetaData().hasTag(sub) || this.advisor.hasAnnotation(this.ctMethod, sub))) {
                    return false;
                }
            } else if (!this.advisor.getMethodMetaData().hasTag(this.refMethod, sub) && !this.advisor.getDefaultMetaData().hasTag(sub)) {
                try {
                    if (!this.advisor.hasAnnotation(this.refMethod, sub)) {
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            if (node.getMethodIdentifier().isImplements() || node.getMethodIdentifier().isImplementing()) {
                try {
                    boolean exactSuper = node.getMethodIdentifier().isImplements();
                    ClassExpression implemented = node.getMethodIdentifier().getImplementsExpression();
                    if (this.ctMethod != null ? Util.methodExistsInSuperClassOrInterface(this.ctMethod, implemented, exactSuper) : Util.methodExistsInSuperClassOrInterface(this.refMethod, implemented, exactSuper)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return false;
            }
            if (!node.getMethodIdentifier().matches(this.methodName)) {
                return false;
            }
        }
        return true;
    }

    protected boolean matchesExceptions(ASTMethod node) {
        block6: {
            ArrayList nodeExceptions = node.getExceptions();
            if (nodeExceptions.size() > 0) {
                if (this.ctMethod != null) {
                    try {
                        if (!Util.matchExceptions(nodeExceptions, this.ctMethod.getExceptionTypes())) {
                            return false;
                        }
                        break block6;
                    }
                    catch (NotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!Util.matchExceptions(nodeExceptions, this.refMethod.getExceptionTypes())) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean matchesReturnType(ASTMethod node) {
        try {
            if (this.ctMethod != null ? !Util.matchesClassExpr(node.getReturnType(), this.ctMethod.getReturnType(), this.advisor) : !Util.matchesClassExpr(node.getReturnType(), this.refMethod.getReturnType(), this.advisor)) {
                return false;
            }
        }
        catch (NotFoundException nfe) {
            throw new RuntimeException(nfe);
        }
        return true;
    }

    protected boolean matchesParameters(ASTMethod node) {
        if (this.ctMethod != null) {
            return Util.matchesParameters(this.advisor, node, this.ctMethod);
        }
        return Util.matchesParameters(this.advisor, node, this.refMethod);
    }
}

