/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public abstract class AbstractAdvice
implements Interceptor,
Untransformable {
    private static final Class[] INVOCATION_SIGNATURE = new Class[]{Invocation.class};
    private static final Class[] METHOD_SIGNATURE = new Class[]{MethodInvocation.class};
    private static final Class[] CONSTRUCTOR_SIGNATURE = new Class[]{ConstructorInvocation.class};
    private static final Class[] FIELD_SIGNATURE = new Class[]{FieldInvocation.class};
    private static final Class[] FIELD_READ_SIGNATURE = new Class[]{FieldReadInvocation.class};
    private static final Class[] FIELD_WRITE_SIGNATURE = new Class[]{FieldWriteInvocation.class};
    private static final Class[] METHOD_CALLED_BY_METHOD_SIGNATURE = new Class[]{MethodCalledByMethodInvocation.class};
    private static final Class[] METHOD_CALLED_BY_CONSTRUCTOR_SIGNATURE = new Class[]{MethodCalledByConstructorInvocation.class};
    private static final Class[] CON_CALLED_BY_METHOD_SIGNATURE = new Class[]{ConstructorCalledByMethodInvocation.class};
    private static final Class[] CON_CALLED_BY_CONSTRUCTOR_SIGNATURE = new Class[]{ConstructorCalledByConstructorInvocation.class};
    protected Method invocationAdvice;
    protected Method methodAdvice;
    protected Method constructorAdvice;
    protected Method fieldAdvice;
    protected Method fieldReadAdvice;
    protected Method fieldWriteAdvice;
    protected Method methodCalledByMethodAdvice;
    protected Method methodCalledByConstructorAdvice;
    protected Method conCalledByMethodAdvice;
    protected Method conCalledByConstructorAdvice;
    protected Class aspectClass;
    protected String adviceName;

    protected void init(String advice, Class aspectClass) {
        this.aspectClass = aspectClass;
        this.adviceName = advice;
        this.invocationAdvice = AbstractAdvice.findByInvocation(this.adviceName, aspectClass);
        if (this.invocationAdvice == null) {
            this.methodAdvice = AbstractAdvice.findByMethodInvocation(this.adviceName, aspectClass);
            this.constructorAdvice = AbstractAdvice.findByConstructorInvocation(this.adviceName, aspectClass);
            this.fieldAdvice = AbstractAdvice.findByFieldInvocation(this.adviceName, aspectClass);
            if (this.fieldAdvice == null) {
                this.fieldReadAdvice = AbstractAdvice.findByFieldReadInvocation(this.adviceName, aspectClass);
                this.fieldWriteAdvice = AbstractAdvice.findByFieldWriteInvocation(this.adviceName, aspectClass);
            }
            this.methodCalledByMethodAdvice = AbstractAdvice.findByMethodCalledByMethodInvocation(this.adviceName, aspectClass);
            this.methodCalledByConstructorAdvice = AbstractAdvice.findByMethodCalledByConstructorInvocation(this.adviceName, aspectClass);
            this.conCalledByMethodAdvice = AbstractAdvice.findByConstructorCalledByMethodInvocation(this.adviceName, aspectClass);
            this.conCalledByConstructorAdvice = AbstractAdvice.findByConstructorCalledByConstructorInvocation(this.adviceName, aspectClass);
        }
    }

    protected static Method findByInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, INVOCATION_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByMethodInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, METHOD_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByFieldInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, FIELD_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByFieldReadInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, FIELD_READ_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByFieldWriteInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, FIELD_WRITE_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByConstructorInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, CONSTRUCTOR_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByMethodCalledByMethodInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, METHOD_CALLED_BY_METHOD_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByMethodCalledByConstructorInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, METHOD_CALLED_BY_CONSTRUCTOR_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByConstructorCalledByMethodInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, CON_CALLED_BY_METHOD_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected static Method findByConstructorCalledByConstructorInvocation(String adviceName, Class clazz) {
        try {
            return clazz.getMethod(adviceName, CON_CALLED_BY_CONSTRUCTOR_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected Method resolveAdvice(Invocation invocation) {
        if (this.invocationAdvice != null) {
            return this.invocationAdvice;
        }
        if (invocation instanceof MethodInvocation) {
            if (this.methodAdvice == null) {
                throw new IllegalStateException("Unable to resolve MethodInvocation advice " + this.getName());
            }
            return this.methodAdvice;
        }
        if (invocation instanceof FieldInvocation) {
            if (this.fieldAdvice != null) {
                return this.fieldAdvice;
            }
            if (invocation instanceof FieldReadInvocation) {
                if (this.fieldReadAdvice == null) {
                    throw new IllegalStateException("Unable to resolve FieldReadInvocation advice " + this.getName());
                }
                return this.fieldReadAdvice;
            }
            if (invocation instanceof FieldWriteInvocation) {
                if (this.fieldWriteAdvice == null) {
                    throw new IllegalStateException("Unable to resolve FieldWriteInvocation advice " + this.getName());
                }
                return this.fieldWriteAdvice;
            }
        }
        if (invocation instanceof ConstructorInvocation) {
            if (this.constructorAdvice == null) {
                throw new IllegalStateException("Unable to resolve ConstructorInvocation advice " + this.getName());
            }
            return this.constructorAdvice;
        }
        if (invocation instanceof MethodCalledByMethodInvocation) {
            if (this.methodCalledByMethodAdvice == null) {
                throw new IllegalStateException("Unable to resolve MethodCalledByMethodInvocation advice " + this.getName());
            }
            return this.methodCalledByMethodAdvice;
        }
        if (invocation instanceof MethodCalledByConstructorInvocation) {
            if (this.methodCalledByConstructorAdvice == null) {
                throw new IllegalStateException("Unable to resolve MethodCalledByConstructorInvocation advice " + this.getName());
            }
            return this.methodCalledByConstructorAdvice;
        }
        if (invocation instanceof ConstructorCalledByMethodInvocation) {
            if (this.conCalledByMethodAdvice == null) {
                throw new IllegalStateException("Unable to resolve ConstructorCalledByMethodInvocation advice " + this.getName());
            }
            return this.conCalledByMethodAdvice;
        }
        if (invocation instanceof ConstructorCalledByConstructorInvocation) {
            if (this.conCalledByMethodAdvice == null) {
                throw new IllegalStateException("Unable to resolve ConstructorCalledByConstructorInvocation advice " + this.getName());
            }
            return this.conCalledByConstructorAdvice;
        }
        throw new RuntimeException("Should Be Unreachable, but unable to discover Advice");
    }
}

