/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DynamicGVTBuilder;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.w3c.dom.svg.SVGDocument;

public class GVTTreeBuilder
extends Thread {
    protected SVGDocument svgDocument;
    protected BridgeContext bridgeContext;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;

    public GVTTreeBuilder(SVGDocument doc, BridgeContext bc) {
        this.svgDocument = doc;
        this.bridgeContext = bc;
    }

    public void run() {
        try {
            this.fireStartedEvent();
            GVTBuilder builder = null;
            builder = this.bridgeContext.isDynamic() ? new DynamicGVTBuilder() : new GVTBuilder();
            GraphicsNode gvtRoot = builder.build(this.bridgeContext, this.svgDocument);
            this.fireCompletedEvent(gvtRoot);
        }
        catch (InterruptedBridgeException e) {
            this.fireCancelledEvent();
        }
        catch (BridgeException e) {
            this.exception = e;
            this.fireFailedEvent(e.getGraphicsNode());
        }
        catch (Exception e) {
            this.exception = e;
            this.fireFailedEvent(null);
        }
        this.bridgeContext.getDocumentLoader().dispose();
    }

    public Exception getException() {
        return this.exception;
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.listeners.add(l);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.listeners.remove(l);
    }

    protected void fireStartedEvent() throws InterruptedException {
        block5: {
            final Object[] dll = this.listeners.toArray();
            if (dll.length <= 0) break block5;
            final GVTTreeBuilderEvent ev = new GVTTreeBuilderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                    dl.gvtBuildStarted(ev);
                    ++i;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int i = 0;
                            while (i < dll.length) {
                                GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                                dl.gvtBuildStarted(ev);
                                ++i;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireCompletedEvent(GraphicsNode root) {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final GVTTreeBuilderEvent ev = new GVTTreeBuilderEvent(this, root);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                    dl.gvtBuildCompleted(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                            dl.gvtBuildCompleted(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent(GraphicsNode root) {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final GVTTreeBuilderEvent ev = new GVTTreeBuilderEvent(this, root);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                    dl.gvtBuildFailed(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                            dl.gvtBuildFailed(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireCancelledEvent() {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final GVTTreeBuilderEvent ev = new GVTTreeBuilderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                    dl.gvtBuildCancelled(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            GVTTreeBuilderListener dl = (GVTTreeBuilderListener)dll[i];
                            dl.gvtBuildCancelled(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }
}

