/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.ShapePainter;

public class StrokeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected Stroke stroke;
    protected Paint paint;

    public StrokeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void setStroke(Stroke newStroke) {
        this.stroke = newStroke;
    }

    public void setPaint(Paint newPaint) {
        this.paint = newPaint;
    }

    public void paint(Graphics2D g2d) {
        if (this.stroke != null && this.paint != null) {
            g2d.setPaint(this.paint);
            g2d.setStroke(this.stroke);
            g2d.draw(this.shape);
        }
    }

    public Shape getPaintedArea() {
        if (this.paint != null && this.stroke != null) {
            return this.stroke.createStrokedShape(this.shape);
        }
        return null;
    }

    public Rectangle2D getPaintedBounds2D() {
        Shape painted = this.getPaintedArea();
        if (painted != null) {
            return painted.getBounds2D();
        }
        return null;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

