/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class SVGGElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "g";
    }

    public Bridge getInstance() {
        return new SVGGElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        Rectangle2D r;
        CompositeGraphicsNode gn = (CompositeGraphicsNode)super.createGraphicsNode(ctx, e);
        if (gn == null) {
            return null;
        }
        RenderingHints hints = CSSUtilities.convertColorRendering(e, null);
        if (hints != null) {
            gn.setRenderingHints(hints);
        }
        if ((r = CSSUtilities.convertEnableBackground(e)) != null) {
            gn.setBackgroundEnable(r);
        }
        return gn;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    public boolean isComposite() {
        return true;
    }

    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)evt.getTarget()));
    }

    public void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        GVTBuilder builder = this.ctx.getGVTBuilder();
        GraphicsNode childNode = builder.build(this.ctx, childElt);
        if (childNode == null) {
            return;
        }
        Node n = parent.getFirstChild();
        Node lastChild = parent.getLastChild();
        if (n == childElt) {
            gn.add(0, childNode);
        } else if (lastChild == childElt) {
            gn.add(childNode);
        } else {
            int index = 0;
            while (n != lastChild && n != childElt) {
                if (n.getNodeType() == 1 && this.ctx.hasGraphicsNodeBridge((Element)n)) {
                    ++index;
                }
                n = n.getNextSibling();
            }
            gn.add(index, childNode);
        }
    }
}

