/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XProperty;
import org.hibernate.type.ByteArrayBlobType;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.PrimitiveByteArrayBlobType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StringClobType;
import org.hibernate.util.StringHelper;

public class SimpleValueBinder {
    private static Log log = LogFactory.getLog(SimpleValueBinder.class);
    private String propertyName;
    private String returnedClassName;
    private Ejb3Column[] columns;
    private String persistentClassName;
    private String explicitType = "";
    private Properties typeParameters = new Properties();
    private ExtendedMappings mappings;

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setType(XProperty property, XClass returnedClass) {
        String type;
        Properties typeParameters;
        XClass returnedClassOrElement;
        block37: {
            boolean isArray;
            block36: {
                boolean isDate;
                if (returnedClass == null) {
                    return;
                }
                returnedClassOrElement = returnedClass;
                isArray = false;
                if (property.isArray()) {
                    returnedClassOrElement = property.getElementClass();
                    isArray = true;
                }
                typeParameters = this.typeParameters;
                typeParameters.clear();
                type = "";
                if (!property.isAnnotationPresent(Temporal.class)) break block36;
                Temporal ann = property.getAnnotation(Temporal.class);
                if (this.mappings.getReflectionManager().equals(property.getType(), Date.class)) {
                    isDate = true;
                } else if (this.mappings.getReflectionManager().equals(property.getType(), Calendar.class)) {
                    isDate = false;
                } else {
                    throw new AnnotationException("@Temporal should be set on a java.util.Date or java.util.Calendar property: " + StringHelper.qualify((String)this.persistentClassName, (String)this.propertyName));
                }
                switch (ann.value()) {
                    case DATE: {
                        type = isDate ? "date" : "calendar_date";
                        break;
                    }
                    case TIME: {
                        type = "time";
                        if (!isDate) {
                            throw new NotYetImplementedException("Calendar cannot persist TIME only" + StringHelper.qualify((String)this.persistentClassName, (String)this.propertyName));
                        }
                        break block37;
                    }
                    case TIMESTAMP: {
                        type = isDate ? "timestamp" : "calendar";
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unknown temporal type: " + ann.value());
                    }
                }
                break block37;
            }
            if (property.isAnnotationPresent(Lob.class)) {
                if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Clob.class)) {
                    type = "clob";
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Blob.class)) {
                    type = "blob";
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, String.class)) {
                    type = StringClobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Character.class) && isArray) {
                    type = CharacterArrayClobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Character.TYPE) && isArray) {
                    type = PrimitiveCharacterArrayClobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Byte.class) && isArray) {
                    type = ByteArrayBlobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(returnedClassOrElement, Byte.TYPE) && isArray) {
                    type = PrimitiveByteArrayBlobType.class.getName();
                } else if (this.mappings.getReflectionManager().toXClass(Serializable.class).isAssignableFrom(returnedClassOrElement)) {
                    type = SerializableToBlobType.class.getName();
                    typeParameters.setProperty("classname", returnedClassOrElement.getName());
                } else {
                    type = "blob";
                }
            }
        }
        if (this.columns == null) {
            throw new AssertionFailure("SimpleValueBinder.setColumns should be set before SimpleValueBinder.setType");
        }
        if ("".equals(type) && returnedClassOrElement.isEnum()) {
            type = org.hibernate.type.EnumType.class.getName();
            typeParameters = new Properties();
            typeParameters.setProperty("enumClass", returnedClassOrElement.getName());
            String schema = this.columns[0].getTable().getSchema();
            schema = schema == null ? "" : schema;
            String catalog = this.columns[0].getTable().getCatalog();
            catalog = catalog == null ? "" : catalog;
            typeParameters.setProperty("schema", schema);
            typeParameters.setProperty("catalog", catalog);
            typeParameters.setProperty("table", this.columns[0].getTable().getName());
            typeParameters.setProperty("column", this.columns[0].getName());
            Enumerated enumAnn = property.getAnnotation(Enumerated.class);
            if (enumAnn != null) {
                EnumType enumType = enumAnn.value();
                if (EnumType.ORDINAL.equals((Object)enumType)) {
                    typeParameters.setProperty("type", String.valueOf(4));
                } else if (EnumType.STRING.equals((Object)enumType)) {
                    typeParameters.setProperty("type", String.valueOf(12));
                } else {
                    throw new AssertionFailure("Unknown EnumType: " + enumType);
                }
            }
        }
        this.explicitType = type;
        this.typeParameters = typeParameters;
        Type annType = property.getAnnotation(Type.class);
        this.setExplicitType(annType);
    }

    public void setExplicitType(String explicitType) {
        this.explicitType = explicitType;
    }

    public void setExplicitType(Type typeAnn) {
        if (typeAnn != null) {
            this.explicitType = typeAnn.type();
            this.typeParameters.clear();
            for (Parameter param : typeAnn.parameters()) {
                this.typeParameters.setProperty(param.name(), param.value());
            }
        }
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public SimpleValue make() {
        this.validate();
        log.debug((Object)("building SimpleValue for " + this.propertyName));
        Table table = this.columns[0].getTable();
        SimpleValue simpleValue = new SimpleValue(table);
        return this.fillSimpleValue(simpleValue);
    }

    private SimpleValue fillSimpleValue(SimpleValue simpleValue) {
        String type = AnnotationBinder.isDefault(this.explicitType) ? this.returnedClassName : this.explicitType;
        TypeDef typeDef = this.mappings.getTypeDef(type);
        if (typeDef != null) {
            type = typeDef.getTypeClass();
            simpleValue.setTypeParameters(typeDef.getParameters());
        }
        if (this.typeParameters != null && this.typeParameters.size() != 0) {
            simpleValue.setTypeParameters(this.typeParameters);
        }
        simpleValue.setTypeName(type);
        if (this.persistentClassName != null) {
            simpleValue.setTypeUsingReflection(this.persistentClassName, this.propertyName);
        }
        for (Ejb3Column column : this.columns) {
            column.linkWithValue(simpleValue);
        }
        return simpleValue;
    }
}

