/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.framework;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.jboss.util.NestedRuntimeException;
import org.objectweb.jtests.jms.admin.Admin;
import org.objectweb.jtests.jms.admin.AdminFactory;
import org.objectweb.jtests.jms.framework.JMSTestCase;

public class UnifiedTestCase
extends JMSTestCase {
    protected Admin admin;
    protected InitialContext ctx;
    private static final String CF_NAME = "testCF";
    private static final String TCF_NAME = "testTCF";
    private static final String QCF_NAME = "testQCF";
    private static final String DESTINATION_NAME = "testDestination";
    private static final String QUEUE_NAME = "testJoramQueue";
    private static final String TOPIC_NAME = "testJoramTopic";
    protected Destination producerDestination;
    protected MessageProducer producer;
    protected ConnectionFactory producerCF;
    protected Connection producerConnection;
    protected Session producerSession;
    protected Destination consumerDestination;
    protected MessageConsumer consumer;
    protected ConnectionFactory consumerCF;
    protected Connection consumerConnection;
    protected Session consumerSession;
    protected QueueConnectionFactory queueConnectionFactory;
    protected Queue queue;
    protected TopicConnectionFactory topicConnectionFactory;
    protected Topic topic;

    protected void setUp() {
        try {
            this.admin = AdminFactory.getAdmin();
            this.admin.createConnectionFactory(CF_NAME);
            this.admin.createQueueConnectionFactory(QCF_NAME);
            this.admin.createTopicConnectionFactory(TCF_NAME);
            this.admin.createQueue(DESTINATION_NAME);
            this.admin.createQueue(QUEUE_NAME);
            this.admin.createTopic(TOPIC_NAME);
            this.ctx = this.admin.createInitialContext();
            this.producerCF = (ConnectionFactory)this.ctx.lookup(CF_NAME);
            this.producerDestination = (Destination)this.ctx.lookup(DESTINATION_NAME);
            this.producerConnection = this.producerCF.createConnection();
            this.producerSession = this.producerConnection.createSession(false, 1);
            this.producer = this.producerSession.createProducer(this.producerDestination);
            this.consumerCF = (ConnectionFactory)this.ctx.lookup(CF_NAME);
            this.consumerDestination = (Destination)this.ctx.lookup(DESTINATION_NAME);
            this.consumerConnection = this.consumerCF.createConnection();
            this.consumerSession = this.consumerConnection.createSession(false, 1);
            this.consumer = this.consumerSession.createConsumer(this.consumerDestination);
            this.queueConnectionFactory = (QueueConnectionFactory)this.ctx.lookup(QCF_NAME);
            this.queue = (Queue)this.ctx.lookup(QUEUE_NAME);
            this.topicConnectionFactory = (TopicConnectionFactory)this.ctx.lookup(TCF_NAME);
            this.topic = (Topic)this.ctx.lookup(TOPIC_NAME);
            this.producerConnection.start();
            this.consumerConnection.start();
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() {
        try {
            try {
                this.consumerConnection.close();
                this.producerConnection.close();
                this.admin.deleteConnectionFactory(CF_NAME);
                this.admin.deleteQueueConnectionFactory(QCF_NAME);
                this.admin.deleteTopicConnectionFactory(TCF_NAME);
                this.admin.deleteQueue(DESTINATION_NAME);
                this.admin.deleteQueue(QUEUE_NAME);
                this.admin.deleteTopic(TOPIC_NAME);
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.producerDestination = null;
                this.producer = null;
                this.producerCF = null;
                this.producerSession = null;
                this.producerConnection = null;
                this.consumerDestination = null;
                this.consumer = null;
                this.consumerCF = null;
                this.consumerSession = null;
                this.consumerConnection = null;
                this.queueConnectionFactory = null;
                this.queue = null;
                this.topicConnectionFactory = null;
                this.topic = null;
            }
            Object var3_1 = null;
            this.producerDestination = null;
            this.producer = null;
            this.producerCF = null;
            this.producerSession = null;
            this.producerConnection = null;
            this.consumerDestination = null;
            this.consumer = null;
            this.consumerCF = null;
            this.consumerSession = null;
            this.consumerConnection = null;
            this.queueConnectionFactory = null;
            this.queue = null;
            this.topicConnectionFactory = null;
            this.topic = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.producerDestination = null;
            this.producer = null;
            this.producerCF = null;
            this.producerSession = null;
            this.producerConnection = null;
            this.consumerDestination = null;
            this.consumer = null;
            this.consumerCF = null;
            this.consumerSession = null;
            this.consumerConnection = null;
            this.queueConnectionFactory = null;
            this.queue = null;
            this.topicConnectionFactory = null;
            this.topic = null;
            throw throwable;
        }
    }

    public UnifiedTestCase(String name) {
        super(name);
    }
}

