/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.connection;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class ConnectionTest
extends PTPTestCase {
    static /* synthetic */ Class class$org$objectweb$jtests$jms$conform$connection$ConnectionTest;

    public void testAcknowledge() {
        try {
            this.receiverConnection.stop();
            this.receiverSession = this.receiverConnection.createQueueSession(false, 2);
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            this.receiverConnection.start();
            Message message = this.senderSession.createMessage();
            this.sender.send(message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            this.receiverConnection.close();
            m.acknowledge();
            ConnectionTest.fail((String)"\ufffd4.3.5 Invoking the acknowledge method of a received message from a closed connection's session must throw a [javax.jms.]IllegalStateException.\n");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            ConnectionTest.fail((String)("\ufffd4.3.5 Invoking the acknowledge method of a received message from a closed connection's session must throw a [javax.jms.]IllegalStateException, not a " + (Object)((Object)e)));
        }
        catch (java.lang.IllegalStateException e) {
            ConnectionTest.fail((String)"\ufffd4.3.5 Invoking the acknowledge method of a received message from a closed connection's session must throw an [javax.jms.]IllegalStateException [not a java.lang.IllegalStateException]");
        }
    }

    public void testUseClosedConnection() {
        try {
            this.senderConnection.close();
            this.senderConnection.createQueueSession(false, 1);
            ConnectionTest.fail((String)"Should raise a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            ConnectionTest.fail((String)("Should raise a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
        catch (java.lang.IllegalStateException e) {
            ConnectionTest.fail((String)"Should raise a javax.jms.IllegalStateException, not a java.lang.IllegalStateException");
        }
    }

    public void testMessageSentWhenConnectionClosed() {
        try {
            this.senderConnection.stop();
            TextMessage message = this.senderSession.createTextMessage();
            this.sender.send((Message)message);
            this.receiver.receive(TestConfig.TIMEOUT);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testCloseClosedConnection() {
        try {
            this.senderConnection.close();
            this.senderConnection.close();
        }
        catch (Exception e) {
            ConnectionTest.fail((String)"\ufffd4.3.5 Closing a closed connection must not throw an exception.\n");
        }
    }

    public void testStartStartedConnection() {
        try {
            this.senderConnection.start();
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testStopStoppedConnection() {
        try {
            this.senderConnection.stop();
            this.senderConnection.stop();
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStopConsumerConnection() {
        try {
            this.receiverConnection.stop();
            this.receiver.setMessageListener(new MessageListener(){

                public void onMessage(Message m) {
                    try {
                        Assert.fail((String)"The message must not be received, the consumer connection is stopped");
                        Assert.assertEquals((String)"test", (String)((TextMessage)m).getText());
                    }
                    catch (JMSException e) {
                        ConnectionTest.this.fail((Exception)((Object)e));
                    }
                }
            });
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("test");
            this.sender.send((Message)message);
            ConnectionTest connectionTest = this;
            synchronized (connectionTest) {
                try {
                    ((Object)((Object)this)).wait(1000L);
                }
                catch (Exception e) {
                    this.fail(e);
                }
            }
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$objectweb$jtests$jms$conform$connection$ConnectionTest == null ? (class$org$objectweb$jtests$jms$conform$connection$ConnectionTest = ConnectionTest.class$("org.objectweb.jtests.jms.conform.connection.ConnectionTest")) : class$org$objectweb$jtests$jms$conform$connection$ConnectionTest);
    }

    public ConnectionTest(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

