/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.admin;

import java.util.Properties;
import org.jboss.util.NestedRuntimeException;
import org.objectweb.jtests.jms.admin.Admin;

public class AdminFactory {
    private static final String PROP_NAME = "jms.provider.admin.class";
    private static final String PROP_FILE_NAME = "provider.properties";

    protected static String getAdminClassName() {
        String adminClassName;
        try {
            Properties props = new Properties();
            props.load(ClassLoader.getSystemResourceAsStream(PROP_FILE_NAME));
            adminClassName = props.getProperty(PROP_NAME);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        return adminClassName;
    }

    public static Admin getAdmin() {
        String adminClassName = AdminFactory.getAdminClassName();
        Admin admin = null;
        if (adminClassName == null) {
            throw new NestedRuntimeException("Property jms.provider.admin.class has not been found in the file provider.properties.");
        }
        try {
            Class<?> adminClass = Class.forName(adminClassName);
            admin = (Admin)adminClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NestedRuntimeException("Class " + adminClassName + " not found.", (Throwable)e);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        return admin;
    }
}

