/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.util.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.juddi.util.Loader;
import org.apache.juddi.util.xml.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private static DocumentBuilder docBuilder = null;

    public static String getText(Element element) {
        StringBuffer textBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            textBuffer.append(nodeList.item(i).getNodeValue());
        }
        return textBuffer.toString().trim();
    }

    public static Vector getChildElementsByTagName(Element element, String tagName) {
        Vector<Node> result = new Vector<Node>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName();
            String localName = node.getLocalName();
            if (localName == null && nodeName != null) {
                localName = nodeName;
            }
            if (node.getNodeType() != 1 || !localName.equals(tagName)) continue;
            result.addElement(node);
        }
        return result;
    }

    public static Element newRootElement() {
        Element element = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element holder = document.createElement("root");
            document.appendChild(holder);
            element = document.getDocumentElement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return element;
    }

    public static Document createDocument() {
        if (docBuilder == null) {
            docBuilder = XMLUtils.createDocumentBuilder();
        }
        return docBuilder.newDocument();
    }

    private static DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        return docBuilder;
    }

    public static void writeXML(Element element, OutputStream stream) {
        try {
            TransformerFactory xformerFactory = TransformerFactory.newInstance();
            Transformer xformer = xformerFactory.newTransformer();
            StreamResult output = new StreamResult(stream);
            DOMSource source = new DOMSource(element);
            xformer.transform(source, output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String toString(Element element) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLUtils.writeXML(element, stream);
        return stream.toString();
    }

    public static void validate(URL xmlDocUrl) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", Loader.getResource("uddi_v2.xsd"));
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Validator handler = new Validator();
            builder.setErrorHandler(handler);
            if (handler.error || handler.warning) {
                System.out.println(handler.toString());
            }
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
    }
}

