/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.datatype.response.TModelList;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class TModelListHandler
extends AbstractHandler {
    public static final String TAG_NAME = "tModelList";
    private HandlerMaker maker = null;

    protected TModelListHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        TModelList obj = new TModelList();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "tModelInfos")).size() > 0) {
            handler = this.maker.lookup("tModelInfos");
            obj.setTModelInfos((TModelInfos)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        TModelInfos infos;
        TModelList list = (TModelList)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = list.getGeneric();
        if (generic != null && generic.trim().length() > 0) {
            element.setAttribute("generic", generic);
            if (generic.equals("1.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api");
            } else if (generic.equals("2.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v2");
            } else if (generic.equals("3.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v3");
            }
        } else {
            element.setAttribute("generic", "2.0");
            element.setAttribute("xmlns", "urn:uddi-org:api_v2");
        }
        String operator = list.getOperator();
        if (operator != null) {
            element.setAttribute("operator", operator);
        } else {
            element.setAttribute("operator", "");
        }
        boolean truncated = list.isTruncated();
        if (truncated) {
            element.setAttribute("truncated", "true");
        }
        if ((infos = list.getTModelInfos()) != null) {
            handler = this.maker.lookup("tModelInfos");
            handler.marshal(infos, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

