/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class DiscoveryURLHandler
extends AbstractHandler {
    public static final String TAG_NAME = "discoveryURL";
    private HandlerMaker maker = null;

    protected DiscoveryURLHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        DiscoveryURL obj = new DiscoveryURL();
        obj.setUseType(element.getAttribute("useType"));
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String urlValue;
        DiscoveryURL discURL = (DiscoveryURL)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        String useType = discURL.getUseType();
        if (useType != null) {
            element.setAttribute("useType", useType);
        }
        if ((urlValue = discURL.getValue()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(urlValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        DiscoveryURL discoveryURL = new DiscoveryURL();
        discoveryURL.setUseType("businessEntity");
        discoveryURL.setValue("http://www.sviens.com");
        System.out.println();
        RegistryObject regObject = discoveryURL;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

