/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.error.AuthTokenExpiredException;
import org.apache.juddi.error.AuthTokenRequiredException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.IFunction;
import org.apache.juddi.registry.RegistryEngine;

public abstract class AbstractFunction
implements IFunction {
    protected RegistryEngine registry = null;

    protected AbstractFunction(RegistryEngine registry) {
        this.registry = registry;
    }

    public RegistryEngine getRegistry() {
        return this.registry;
    }

    public void setRegistry(RegistryEngine registry) {
        this.registry = registry;
    }

    protected Publisher getPublisher(AuthInfo authInfo, DataStore dataStore) throws RegistryException {
        Publisher publisher = null;
        if (authInfo == null || authInfo.getValue() == null) {
            throw new AuthTokenRequiredException("authToken: null");
        }
        String authToken = authInfo.getValue();
        if (authToken.trim().length() == 0) {
            throw new AuthTokenRequiredException("authToken: " + authToken);
        }
        publisher = dataStore.getAuthTokenPublisher(authToken);
        if (publisher == null) {
            throw new AuthTokenRequiredException("authToken: " + authToken);
        }
        if (dataStore.isAuthTokenExpired(authToken)) {
            throw new AuthTokenExpiredException("authToken: " + authToken);
        }
        dataStore.touchAuthToken(authToken);
        return publisher;
    }
}

