/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.auth.Authenticator;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;

public class AuthenticatorFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$auth$AuthenticatorFactory == null ? (class$org$apache$juddi$auth$AuthenticatorFactory = AuthenticatorFactory.class$("org.apache.juddi.auth.AuthenticatorFactory")) : class$org$apache$juddi$auth$AuthenticatorFactory));
    private static final String IMPL_KEY = "juddi.auth";
    private static final String DEFAULT_IMPL = "org.apache.juddi.auth.DefaultAuthenticator";
    private static Authenticator auth = null;
    static /* synthetic */ Class class$org$apache$juddi$auth$AuthenticatorFactory;

    public static Authenticator getAuthenticator() {
        if (auth == null) {
            auth = AuthenticatorFactory.createAuthenticator();
        }
        return auth;
    }

    private static synchronized Authenticator createAuthenticator() {
        if (auth != null) {
            return auth;
        }
        String className = Config.getStringProperty(IMPL_KEY, DEFAULT_IMPL);
        log.debug((Object)("Authenticator Implementation = " + className));
        Class authClass = null;
        try {
            authClass = Loader.getClassForName(className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Authenticator class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        try {
            auth = (Authenticator)authClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of Authenticator: " + authClass.getName() + "\n" + e.getMessage()));
            log.error((Object)e);
        }
        return auth;
    }

    public static void main(String[] args) throws Exception {
        Authenticator auth = AuthenticatorFactory.getAuthenticator();
        if (auth != null) {
            System.out.println("Got Authenticator: " + auth.getClass().getName());
            String userID = auth.authenticate("sviens", "password");
            System.out.println("The id " + userID + " was successfully authenticated.");
        } else {
            System.out.println("Sorry: getAuthenticator returned 'null'.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

