/*
 * Decompiled with CFR 0.152.
 */
package components.renderkit;

import components.renderkit.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;

public abstract class BaseRenderer
extends Renderer {
    public static final String BUNDLE_ATTR = "com.sun.faces.bundle";

    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    protected String getKeyAndLookupInBundle(FacesContext context, UIComponent component, String keyAttr) throws MissingResourceException {
        String key = null;
        String bundleName = null;
        ResourceBundle bundle = null;
        key = (String)component.getAttributes().get(keyAttr);
        bundleName = (String)component.getAttributes().get(BUNDLE_ATTR);
        if (bundleName == null) {
            UIViewRoot root = context.getViewRoot();
            bundleName = (String)root.getAttributes().get(BUNDLE_ATTR);
        }
        if (null == key || null == bundleName) {
            throw new MissingResourceException("Can't load JSTL classes", bundleName, key);
        }
        if (null == Thread.currentThread().getContextClassLoader().getResource("javax.servlet.jsp.jstl.fmt.LocalizationContext")) {
            Object[] params = new Object[]{"javax.servlet.jsp.jstl.fmt.LocalizationContext"};
            throw new MissingResourceException("Can't load JSTL classes", bundleName, key);
        }
        LocalizationContext locCtx = null;
        locCtx = (LocalizationContext)Util.getValueBinding(bundleName).getValue(context);
        if (null == locCtx || null == (bundle = locCtx.getResourceBundle())) {
            throw new MissingResourceException("Can't load ResourceBundle ", bundleName, key);
        }
        return bundle.getString(key);
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }
}

