/*
 * Decompiled with CFR 0.152.
 */
package components.model;

import components.model.Node;
import java.util.HashMap;
import java.util.Iterator;

public class Graph {
    protected HashMap registry = new HashMap();
    private Node root = null;
    private Node selected = null;

    public Graph() {
    }

    public Graph(Node root) {
        this.setRoot(root);
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        this.setSelected(null);
        if (this.root != null) {
            this.removeNode(this.root);
        }
        if (root != null) {
            this.addNode(root);
        }
        root.setLast(true);
        this.root = root;
    }

    public Node getSelected() {
        return this.selected;
    }

    public void setSelected(Node selected) {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = selected;
        if (this.selected != null) {
            this.selected.setSelected(true);
        }
    }

    public Node findNode(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        Node node = this.getRoot();
        path = path.substring(1);
        while (path.length() > 0) {
            String name = null;
            int slash = path.indexOf("/");
            if (slash < 0) {
                name = path;
                path = "";
            } else {
                name = path.substring(0, slash);
                path = path.substring(slash + 1);
            }
            node = node.findChild(name);
            if (node != null) continue;
            return null;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(Node node) throws IllegalArgumentException {
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            String name = node.getName();
            if (this.registry.containsKey(name)) {
                throw new IllegalArgumentException("Name '" + name + "' is not unique");
            }
            node.setGraph(this);
            this.registry.put(name, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNode(Node node) {
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            Iterator nodeItr = node.getChildren();
            while (nodeItr.hasNext()) {
                this.removeNode((Node)nodeItr.next());
            }
            node.setParent(null);
            node.setGraph(null);
            if (node == this.root) {
                this.root = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node findNodeByName(String nodename) {
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            return (Node)this.registry.get(nodename);
        }
    }
}

